/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.mapconverter.internal;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.tuple.TupleTwo;

public class BeanToNestedMapUnMarshaller<B> {
    private Class<? extends B> beanClass = null;
    private Map<Map<String, Object>, Object> mapToObjectMap = new IdentityHashMap<Map<String, Object>, Object>();
    private Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap = null;

    public BeanToNestedMapUnMarshaller(Class<? extends B> beanClass, Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap) {
        this.beanClass = beanClass;
        this.sourceTypeTodestinationTypeMap = sourceTypeTodestinationTypeMap;
    }

    public B unmarshal(Map<String, Object> map, BeanPropertyAccessor.PropertyAccessType propertyAccessType) {
        return (B)this.unmarshalToObject(map, propertyAccessType);
    }

    private Object unmarshalToObject(Map<String, Object> map, BeanPropertyAccessor.PropertyAccessType propertyAccessType) {
        Object retval = null;
        final BeanPropertyAccessor.PropertyAccessType propertyAccessTypeFinal = propertyAccessType != null ? propertyAccessType : BeanPropertyAccessor.PropertyAccessType.PROPERTY;
        final class Helper {
            Helper() {
            }

            public Object convertValueIfNecessary(Object value, Class<?> propertyType) {
                Object retval = value;
                if (value instanceof Map && propertyType != null && ((Map)value).containsKey("clazz")) {
                    Map subMap = (Map)value;
                    retval = BeanToNestedMapUnMarshaller.this.unmarshalToObject(subMap, propertyAccessTypeFinal);
                    BeanToNestedMapUnMarshaller.this.mapToObjectMap.put(subMap, retval);
                }
                return retval;
            }
        }
        Helper helper = new Helper();
        if (map != null) {
            if (this.mapToObjectMap.containsKey(map)) {
                retval = this.mapToObjectMap.get(map);
            } else {
                B beanNew;
                Class<Object> objectClass = this.beanClass;
                String canonicalClassName = (String)map.get("clazz");
                if (canonicalClassName != null) {
                    objectClass = BeanToNestedMapUnMarshaller.determineObjectClass(canonicalClassName);
                }
                if (this.sourceTypeTodestinationTypeMap != null && this.sourceTypeTodestinationTypeMap.containsKey(objectClass)) {
                    objectClass = this.sourceTypeTodestinationTypeMap.get(objectClass);
                }
                if ((beanNew = ReflectionUtils.newInstanceOf(objectClass, new Object[0])) != null) {
                    if (beanNew instanceof Collection) {
                        Collection collection = (Collection)beanNew;
                        for (String counterString : new TreeSet<String>(map.keySet())) {
                            if ("clazz".equals(counterString)) continue;
                            Object object = map.get(counterString);
                            Class<Object> propertyType = Object.class;
                            Object object2 = helper.convertValueIfNecessary(object, propertyType);
                            collection.add(object2);
                        }
                    } else if (beanNew instanceof Map) {
                        Map mapInstance = (Map)beanNew;
                        TreeMap<String, TupleTwo<Object, Object>> counterStringToKeyAndValueMap = new TreeMap<String, TupleTwo<Object, Object>>();
                        for (String string : new TreeSet<String>(map.keySet())) {
                            String key;
                            if (string == null || "clazz".equals(string)) continue;
                            Object value = map.get(string);
                            Class<Object> propertyType = Object.class;
                            value = helper.convertValueIfNecessary(value, propertyType);
                            if (string.endsWith("key")) {
                                key = string.replaceAll("key$", "");
                                counterStringToKeyAndValueMap.put(key, new TupleTwo<Object, Object>(value, null));
                                continue;
                            }
                            if (!string.endsWith("value")) continue;
                            key = string.replaceAll("value$", "");
                            ((TupleTwo)counterStringToKeyAndValueMap.get(key)).setValueSecond(value);
                        }
                        for (Map.Entry entry : counterStringToKeyAndValueMap.entrySet()) {
                            TupleTwo keyAndValue = (TupleTwo)entry.getValue();
                            mapInstance.put(keyAndValue.getValueFirst(), keyAndValue.getValueSecond());
                        }
                    } else {
                        Map<String, BeanPropertyAccessor<B>> propertyNameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(objectClass);
                        for (String propertyName : propertyNameToBeanPropertyAccessorMap.keySet()) {
                            BeanPropertyAccessor<B> beanPropertyAccessor = propertyNameToBeanPropertyAccessorMap.get(propertyName).newBeanPropertyAccessorWithPropertyAccessType(propertyAccessType);
                            if (!beanPropertyAccessor.isWritable()) continue;
                            Object value = map.get(propertyName);
                            if (value == null) {
                                beanPropertyAccessor.setPropertyValue(beanNew, value);
                                continue;
                            }
                            Class<?> propertyType = beanPropertyAccessor.getDeclaringPropertyType();
                            value = helper.convertValueIfNecessary(value, propertyType);
                            beanPropertyAccessor.setPropertyValue(beanNew, value);
                        }
                    }
                    retval = beanNew;
                }
            }
        }
        return retval;
    }

    private static Class<Object> determineObjectClass(String className) {
        Class<?> retval = null;
        if (className != null) {
            try {
                retval = Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }
}

