/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.replicator.ConverterPipeManager;
import org.omnaest.utils.beans.replicator.ConverterPipeManagerImpl;
import org.omnaest.utils.beans.replicator.CopyException;
import org.omnaest.utils.beans.replicator.FactoryResolver;
import org.omnaest.utils.beans.replicator.FactoryResolverImpl;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.InstanceAccessorResolver;
import org.omnaest.utils.beans.replicator.InstanceAccessorResolverImpl;
import org.omnaest.utils.beans.replicator.InstanceCache;
import org.omnaest.utils.beans.replicator.InstanceCacheImpl;
import org.omnaest.utils.beans.replicator.InstanceFactory;
import org.omnaest.utils.beans.replicator.NoMatchingPropertiesException;
import org.omnaest.utils.beans.replicator.Path;
import org.omnaest.utils.beans.replicator.Pipe;
import org.omnaest.utils.beans.replicator.PreservationAndIgnorationDeclarer;
import org.omnaest.utils.beans.replicator.PreservationAndIgnorationManager;
import org.omnaest.utils.beans.replicator.PreservationAndIgnorationManagerImpl;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.beans.replicator.PropertyNameAndType;
import org.omnaest.utils.beans.replicator.TypeToTypeMappingDeclarer;
import org.omnaest.utils.beans.replicator.TypeToTypeMappingManager;
import org.omnaest.utils.beans.replicator.TypeToTypeMappingManagerImpl;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerDelegate;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterSerializable;

public class BeanReplicator<FROM, TO>
implements Serializable {
    private static final long serialVersionUID = -5403362205184966835L;
    private final Class<FROM> sourceType;
    private final Class<TO> targetType;
    private final FactoryResolver factoryResolver;
    private final InstanceAccessorResolver instanceAccessorResolver;
    private final PreservationAndIgnorationManager preservationAndIgnorationManager;
    private final TypeToTypeMappingManager typeToTypeMappingManager;
    private final ConverterPipeManager converterPipeManager;
    private final ExceptionHandlerDelegate exceptionHandler = new ExceptionHandlerDelegate(new ExceptionHandlerIgnoring());
    private final AtomicBoolean hasCopiedOnce = new AtomicBoolean(false);

    public BeanReplicator(Class<? super FROM> sourceType, Class<? extends TO> targetType) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.factoryResolver = new FactoryResolverImpl();
        this.instanceAccessorResolver = new InstanceAccessorResolverImpl(this.exceptionHandler);
        this.preservationAndIgnorationManager = new PreservationAndIgnorationManagerImpl();
        this.typeToTypeMappingManager = new TypeToTypeMappingManagerImpl();
        this.typeToTypeMappingManager.addTypeMappingForPath("", sourceType, targetType);
        this.converterPipeManager = new ConverterPipeManagerImpl();
        BeanReplicator.initializeConverterPipeManager(this.converterPipeManager);
    }

    private static void initializeConverterPipeManager(ConverterPipeManager converterPipeManager) {
        ElementConverterSerializable<Comparable<Date>, Comparable<Date>> elementConverter = new ElementConverterSerializable<Date, Date>(){
            private static final long serialVersionUID = -8170416497828888204L;

            @Override
            public Date convert(Date date) {
                return new Date(date.getTime());
            }
        };
        converterPipeManager.addConverterPipeFrom(Date.class).over(elementConverter).to(Date.class);
        elementConverter = new ElementConverterSerializable<Calendar, Calendar>(){
            private static final long serialVersionUID = 8770104025185376953L;

            @Override
            public Calendar convert(Calendar calendarFrom) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(calendarFrom.getTime());
                return calendar;
            }
        };
        converterPipeManager.addConverterPipeFrom(Calendar.class).over(elementConverter).to(Calendar.class);
        elementConverter = new ElementConverterSerializable<Date, Calendar>(){
            private static final long serialVersionUID = -2711841719554089887L;

            @Override
            public Calendar convert(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
        };
        converterPipeManager.addConverterPipeFrom(Date.class).over(elementConverter).to(Calendar.class);
        elementConverter = new ElementConverterSerializable<Calendar, Date>(){
            private static final long serialVersionUID = 1110860863721796033L;

            @Override
            public Date convert(Calendar calendarFrom) {
                return calendarFrom.getTime();
            }
        };
        converterPipeManager.addConverterPipeFrom(Calendar.class).over(elementConverter).to(Date.class);
    }

    public TO clone(FROM source) {
        TO retval = null;
        try {
            InstanceFactory factory = this.factoryResolver.resolveFactory(this.targetType);
            if (factory != null) {
                retval = (TO)factory.newInstance(this.determineFactoryMetaInformation(this.sourceType, source));
                Assert.isNotNull(retval, "Failed to create instance of type " + this.sourceType);
                this.copy(source, retval);
            }
        }
        catch (Exception e) {
            String canonicalPath = "";
            this.exceptionHandler.handleException(new CopyException(e, ""));
        }
        return retval;
    }

    public void copy(FROM source, TO target) {
        InstanceCacheImpl instanceCache = new InstanceCacheImpl();
        Class<FROM> sourceType = this.sourceType;
        Class<TO> targetType = this.targetType;
        Path path = new Path();
        this.copy(source, target, instanceCache, sourceType, targetType, path);
    }

    private void copy(Object source, Object target, InstanceCache instanceCache, Class<?> sourceType, Class<?> targetType, Path path) {
        try {
            if (source != null && sourceType != null && target != null && targetType != null) {
                this.hasCopiedOnce.compareAndSet(false, true);
                InstanceAccessor instanceAccessorSource = this.instanceAccessorResolver.resolveInstanceAccessor(sourceType);
                InstanceAccessor instanceAccessorTarget = this.instanceAccessorResolver.resolveInstanceAccessor(targetType);
                if (instanceAccessorSource != null && instanceAccessorTarget != null) {
                    for (String propertyName : instanceAccessorSource.getPropertyNameIterable(source)) {
                        try {
                            PropertyAccessor propertySource;
                            Path subPath = new Path(path, propertyName);
                            if (this.preservationAndIgnorationManager.isIgnoredPath(subPath) || (propertySource = instanceAccessorSource.getPropertyAccessor(propertyName, source)) == null) continue;
                            Object valueReplica = null;
                            Class<?> propertySourceType = propertySource.getType();
                            if (propertySourceType == null || this.preservationAndIgnorationManager.isIgnoredType(propertySourceType)) continue;
                            PropertyNameAndType remapping = this.typeToTypeMappingManager.determineRemapping(propertyName, propertySourceType, path);
                            String propertyNameWithinTarget = BeanReplicator.determinePropertyNameWithinTarget(propertyName, remapping);
                            PropertyAccessor propertyTarget = instanceAccessorTarget.getPropertyAccessor(propertyNameWithinTarget, target);
                            Class<?> propertyTargetType = BeanReplicator.determinePropertyTargetType(propertyTarget, propertySourceType, remapping);
                            Pipe<Object, Object> converterPipe = this.converterPipeManager.resolveConverterPipeFor(propertySourceType, propertyTargetType);
                            if (propertyTargetType == null && converterPipe == null) {
                                String canonicalPath = subPath.getCanonicalPath();
                                String propertyNameSource = propertyName;
                                String propertyNameTarget = propertyNameWithinTarget;
                                throw new NoMatchingPropertiesException(canonicalPath, propertySourceType, propertyNameSource, targetType, propertyNameTarget);
                            }
                            Object value = propertySource.getValue();
                            if (converterPipe != null) {
                                valueReplica = converterPipe.convert(value);
                            } else if (value != null) {
                                boolean isPreservedInstance;
                                boolean isPrimitiveOrPrimitiveWrapperOrStringType = ObjectUtils.isPrimitiveOrPrimitiveWrapperType(propertySourceType) || String.class.equals(propertySourceType);
                                boolean bl = isPreservedInstance = this.preservationAndIgnorationManager.isPreservedType(propertySourceType) || this.preservationAndIgnorationManager.isPreservedPath(subPath);
                                if (isPrimitiveOrPrimitiveWrapperOrStringType || isPreservedInstance) {
                                    valueReplica = isPreservedInstance ? value : (propertyTargetType != null && propertyTargetType.isAssignableFrom(propertySourceType) ? value : ObjectUtils.castTo(propertyTargetType, value));
                                } else {
                                    InstanceFactory factory;
                                    valueReplica = instanceCache.getReplicaInstance(propertyTargetType, value);
                                    if (valueReplica == null && (factory = this.factoryResolver.resolveFactory(propertyTargetType)) != null) {
                                        Map<String, Object> factoryMetaInformation = this.determineFactoryMetaInformation(propertySourceType, value);
                                        valueReplica = factory.newInstance(factoryMetaInformation);
                                        this.copy(value, valueReplica, instanceCache, propertySourceType, propertyTargetType, subPath);
                                        instanceCache.addReplicaInstance(propertyTargetType, value, valueReplica);
                                    }
                                }
                            }
                            propertyTarget.setValue(valueReplica);
                        }
                        catch (CopyException e) {
                            this.exceptionHandler.handleException(e);
                        }
                        catch (Exception e) {
                            String canonicalPath = path.getCanonicalPath() + "." + propertyName;
                            this.exceptionHandler.handleException(new CopyException(e, canonicalPath));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String canonicalPath = path.getCanonicalPath();
            this.exceptionHandler.handleException(new CopyException(e, canonicalPath));
        }
    }

    private Map<String, Object> determineFactoryMetaInformation(Class<?> propertySourceType, Object instance) {
        InstanceAccessor instanceAccessor = this.instanceAccessorResolver.resolveInstanceAccessor(propertySourceType);
        Map<String, Object> factoryMetaInformation = instanceAccessor != null ? instanceAccessor.determineFactoryMetaInformation(instance) : null;
        return factoryMetaInformation;
    }

    private static String determinePropertyNameWithinTarget(String propertyName, PropertyNameAndType remapping) {
        return remapping != null ? remapping.getPropertyName() : propertyName;
    }

    private static Class<?> determinePropertyTargetType(PropertyAccessor propertyTarget, Class<?> propertySourceType, PropertyNameAndType remapping) {
        Class<?> retval = null;
        if (remapping == null) {
            if (propertyTarget != null && (retval = propertyTarget.getType()) == null) {
                retval = propertySourceType;
            }
        } else {
            retval = remapping.getType();
        }
        return retval;
    }

    public BeanReplicator<FROM, TO> declare(Declaration declaration) {
        Assert.isFalse(this.hasCopiedOnce.get(), "Declarations must be specified before any call to copy or clone");
        final TypeToTypeMappingManager typeToTypeMappingManager = this.typeToTypeMappingManager;
        if (declaration != null) {
            DeclarationSupport support = new DeclarationSupport(){
                private static final long serialVersionUID = 3224104919381023723L;

                @Override
                public void addTypeMapping(Class<?> typeFrom, Class<?> typeTo) {
                    typeToTypeMappingManager.addTypeMapping(typeFrom, typeTo);
                }

                @Override
                public void addTypeAndPropertyNameMapping(Class<?> typeFrom, String propertyNameFrom, Class<?> typeTo, String propertyNameTo) {
                    typeToTypeMappingManager.addTypeAndPropertyNameMapping(typeFrom, propertyNameFrom, typeTo, propertyNameTo);
                }

                @Override
                public void addPropertyNameMapping(String propertyNameFrom, String propertyNameTo) {
                    typeToTypeMappingManager.addPropertyNameMapping(propertyNameFrom, propertyNameTo);
                }

                @Override
                public void addPropertyNameMapping(String path, String propertyNameFrom, String propertyNameTo) {
                    typeToTypeMappingManager.addPropertyNameMapping(path, propertyNameFrom, propertyNameTo);
                }

                @Override
                public void addTypeAndPropertyNameMapping(String path, Class<?> typeFrom, String propertyNameFrom, Class<?> typeTo, String propertyNameTo) {
                    typeToTypeMappingManager.addTypeAndPropertyNameMapping(path, typeFrom, propertyNameFrom, typeTo, propertyNameTo);
                }

                @Override
                public void addTypeMappingForPath(String path, Class<?> typeFrom, Class<?> typeTo) {
                    typeToTypeMappingManager.addTypeMappingForPath(path, typeFrom, typeTo);
                }

                public <FROM2> PipeBuilder<FROM2, FROM2> addConverterPipeFrom(Class<FROM2> typeFrom) {
                    return BeanReplicator.this.converterPipeManager.addConverterPipeFrom(typeFrom);
                }

                @Override
                public void addAllPreservedTypes(Iterable<? extends Class<?>> typeIterable) {
                    BeanReplicator.this.preservationAndIgnorationManager.addAllPreservedTypes(typeIterable);
                }

                @Override
                public void addPreservedType(Class<?> type) {
                    BeanReplicator.this.preservationAndIgnorationManager.addPreservedType(type);
                }

                @Override
                public void addPreservedPath(String path) {
                    BeanReplicator.this.preservationAndIgnorationManager.addPreservedPath(path);
                }

                @Override
                public void setPreservedDeepnessLevel(int deepnessLevel) {
                    BeanReplicator.this.preservationAndIgnorationManager.setPreservedDeepnessLevel(deepnessLevel);
                }

                @Override
                public void setIgnoredDeepnessLevel(int deepnessLevel) {
                    BeanReplicator.this.preservationAndIgnorationManager.setIgnoredDeepnessLevel(deepnessLevel);
                }

                @Override
                public void addAllIgnoredTypes(Iterable<? extends Class<?>> typeIterable) {
                    BeanReplicator.this.preservationAndIgnorationManager.addAllIgnoredTypes(typeIterable);
                }

                @Override
                public void addIgnoredType(Class<?> type) {
                    BeanReplicator.this.preservationAndIgnorationManager.addIgnoredType(type);
                }

                @Override
                public void addIgnoredPath(String path) {
                    BeanReplicator.this.preservationAndIgnorationManager.addIgnoredPath(path);
                }
            };
            declaration.declare(support);
        }
        return this;
    }

    public BeanReplicator<FROM, TO> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler.setExceptionHandler(ObjectUtils.defaultIfNull(exceptionHandler, new ExceptionHandlerIgnoring()));
        return this;
    }

    public static interface Declaration
    extends Serializable {
        public void declare(DeclarationSupport var1);
    }

    public static interface DeclarationSupport
    extends TypeToTypeMappingDeclarer,
    ConverterPipeDeclarer,
    PreservationAndIgnorationDeclarer {
    }

    public static interface ConverterPipeDeclarer
    extends Serializable {
        public <FROM> PipeBuilder<FROM, FROM> addConverterPipeFrom(Class<FROM> var1);
    }

    public static interface PipeBuilder<FROM, TO> {
        public <OVER> PipeBuilder<FROM, OVER> over(ElementConverter<FROM, OVER> var1);

        public void to(Class<TO> var1);
    }
}

