/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omnaest.utils.beans.replicator.BeanReplicator;
import org.omnaest.utils.beans.replicator.ConverterPipeContainer;
import org.omnaest.utils.beans.replicator.ConverterPipeManager;
import org.omnaest.utils.beans.replicator.Pipe;
import org.omnaest.utils.beans.replicator.TypeAndType;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;

class ConverterPipeManagerImpl
implements ConverterPipeManager,
ConverterPipeContainer {
    private static final long serialVersionUID = -5610874488869665883L;
    private Map<TypeAndType, Pipe<?, ?>> typeAndTypeToPipeMap = new HashMap();

    ConverterPipeManagerImpl() {
    }

    @Override
    public <FROM> BeanReplicator.PipeBuilder<FROM, FROM> addConverterPipeFrom(Class<FROM> typeFrom) {
        return new PipeBuilderImpl(typeFrom, this);
    }

    @Override
    public void add(Pipe<?, ?> pipe) {
        TypeAndType key = pipe.getTypeAndType();
        Pipe<?, ?> value = pipe;
        this.typeAndTypeToPipeMap.put(key, value);
    }

    @Override
    public Pipe<Object, Object> resolveConverterPipeFor(Class<?> typeFrom, Class<?> typeTo) {
        return this.typeAndTypeToPipeMap.get(new TypeAndType(typeFrom, typeTo));
    }

    private static final class PipeBuilderImpl<FROM, TO>
    implements BeanReplicator.PipeBuilder<FROM, TO> {
        private final List<ElementConverter<?, ?>> elementConverterList;
        private final Class<FROM> typeFrom;
        private final ConverterPipeContainer converterPipeContainer;

        PipeBuilderImpl(Class<FROM> typeFrom, ConverterPipeContainer converterPipeContainer) {
            this.typeFrom = typeFrom;
            this.converterPipeContainer = converterPipeContainer;
            this.elementConverterList = null;
        }

        private PipeBuilderImpl(Class<FROM> typeFrom, List<ElementConverter<?, ?>> elementConverterList, ConverterPipeContainer converterPipeContainer) {
            this.typeFrom = typeFrom;
            this.elementConverterList = elementConverterList;
            this.converterPipeContainer = converterPipeContainer;
        }

        @Override
        public void to(Class<TO> typeTo) {
            ElementConverter[] elementConverters = this.elementConverterList.toArray(new ElementConverter[0]);
            Pipe<FROM, TO> pipe = new Pipe<FROM, TO>(this.typeFrom, typeTo, elementConverters);
            this.converterPipeContainer.add(pipe);
        }

        @Override
        public <OVER> BeanReplicator.PipeBuilder<FROM, OVER> over(ElementConverter<FROM, OVER> elementConverter) {
            return new PipeBuilderImpl<FROM, TO>(this.typeFrom, ListUtils.addToNewList(this.elementConverterList, elementConverter), this.converterPipeContainer);
        }
    }
}

