/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.adapter.PropertynameMapToTypeAdapter;
import org.omnaest.utils.beans.replicator.FactoryResolver;
import org.omnaest.utils.beans.replicator.InstanceFactory;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;

class FactoryResolverImpl
implements FactoryResolver {
    private static final long serialVersionUID = 971678462369981695L;
    private Map<Class<?>, InstanceFactory> typeToFactoryMap = FactoryResolverImpl.newInitializedTypeToFactoryMap();

    FactoryResolverImpl() {
    }

    private static Map<Class<?>, InstanceFactory> newInitializedTypeToFactoryMap() {
        return MapUtils.builder().put(HashMap.class, new HashMapFactory()).put(LinkedHashMap.class, (HashMapFactory)((Object)new LinkedHashMapFactory())).put(ConcurrentHashMap.class, (HashMapFactory)((Object)new ConcurrentHashMapFactory())).put(ConcurrentSkipListMap.class, (HashMapFactory)((Object)new ConcurrentSkipListMapFactory())).put(HashSet.class, (HashMapFactory)((Object)new HashSetFactory())).put(TreeSet.class, (HashMapFactory)((Object)new TreeSetFactory())).put(LinkedHashSet.class, (HashMapFactory)((Object)new LinkedHashSetFactory())).buildAs().concurrentHashMap();
    }

    @Override
    public InstanceFactory resolveFactory(final Class<?> type) {
        InstanceFactory factory = this.typeToFactoryMap.get(type);
        if (factory == null) {
            factory = MapUtils.isSortedMapType(type) ? new TreeMapFactory() : (MapUtils.isMapType(type) ? new LinkedHashMapFactory() : (ListUtils.isListType(type) ? new ArrayListFactory() : (ArrayUtils.isArrayType(type) ? new ArrayFactory(type) : (SetUtils.isSortedSetType(type) ? new TreeSetFactory() : (SetUtils.isSetType(type) ? new LinkedHashSetFactory() : (IterableUtils.isIterableType(type) ? new ArrayListFactory() : (type.isInterface() ? new InstanceFactory(){
                private static final long serialVersionUID = -3100752693360156274L;
                private PropertynameMapToTypeAdapter.Builder<?> builder;
                {
                    this.builder = PropertynameMapToTypeAdapter.builder(type, new PropertynameMapToTypeAdapter.Configuration());
                }

                @Override
                public Object newInstance(Map<String, Object> parameterMap) {
                    Object retval = this.builder.newTypeAdapter(new HashMap());
                    Assert.isNotNull(retval, "Failed to create proxy instance of type " + type);
                    return retval;
                }
            } : new InstanceFactory(){
                private static final long serialVersionUID = -5458144693782050218L;

                @Override
                public Object newInstance(Map<String, Object> parameterMap) {
                    Object retval = ReflectionUtils.newInstanceOf(type, new Object[0]);
                    Assert.isNotNull(retval, "Failed to create instance of type " + type);
                    return retval;
                }
            })))))));
            this.typeToFactoryMap.put(type, factory);
        }
        return factory;
    }

    private static final class ConcurrentSkipListMapFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -8296675902240723281L;

        private ConcurrentSkipListMapFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            Comparator comparator = (Comparator)(parameterMap != null ? parameterMap.get("comparator") : null);
            return comparator != null ? new ConcurrentSkipListMap(comparator) : new ConcurrentSkipListMap();
        }
    }

    private static final class ConcurrentHashMapFactory
    implements InstanceFactory {
        private static final long serialVersionUID = 4781745850743187459L;

        private ConcurrentHashMapFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new ConcurrentHashMap();
        }
    }

    private static final class HashMapFactory
    implements InstanceFactory {
        private static final long serialVersionUID = 4781955850743187459L;

        private HashMapFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new HashMap();
        }
    }

    private static final class TreeSetFactory
    implements InstanceFactory {
        private static final long serialVersionUID = 4609633205635635614L;

        private TreeSetFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            Comparator comparator = parameterMap != null ? (Comparator)parameterMap.get("comparator") : null;
            return comparator != null ? new TreeSet(comparator) : new TreeSet();
        }
    }

    private static final class TreeMapFactory
    implements InstanceFactory {
        private static final long serialVersionUID = 7216896364811227889L;

        private TreeMapFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            Comparator comparator = parameterMap != null ? (Comparator)parameterMap.get("comparator") : null;
            return comparator != null ? new TreeMap(comparator) : new TreeMap();
        }
    }

    private static final class LinkedHashMapFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -42829675978851169L;

        private LinkedHashMapFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new LinkedHashMap();
        }
    }

    private static final class ArrayListFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -5519865687797126874L;

        private ArrayListFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new ArrayList();
        }
    }

    private static final class ArrayFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -4135079052234294623L;
        private final Class<?> type;

        public ArrayFactory(Class<?> type) {
            this.type = type;
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            Assert.isNotNull(parameterMap, "Factory for arrays is incompatible with the respective source instance accessor. The instance accessor has to provide a parameter map containing the 'size' key with the expected size of the array");
            Integer size = (Integer)parameterMap.get("size");
            return Array.newInstance(ArrayUtils.componentType(this.type), (int)size);
        }
    }

    private static final class HashSetFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -689574345649478523L;

        private HashSetFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new HashSet();
        }
    }

    private static final class LinkedHashSetFactory
    implements InstanceFactory {
        private static final long serialVersionUID = -6895746761649478523L;

        private LinkedHashSetFactory() {
        }

        @Override
        public Object newInstance(Map<String, Object> parameterMap) {
            return new LinkedHashSet();
        }
    }
}

