/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.events.exception.ExceptionHandler;

class InstanceAccessorArbitraryObject
implements InstanceAccessor {
    private static final long serialVersionUID = 7255593284457472131L;
    private final Map<String, BeanPropertyAccessor<?>> propertyNameToBeanPropertyAccessorMap;
    private final Class<?> type;
    private final ExceptionHandler exceptionHandler;

    InstanceAccessorArbitraryObject(Class<?> type, ExceptionHandler exceptionHandler) {
        this.type = type;
        this.exceptionHandler = exceptionHandler;
        this.propertyNameToBeanPropertyAccessorMap = ImmutableMap.copyOf(BeanUtils.propertyNameToBeanPropertyAccessorMap(type));
    }

    @Override
    public PropertyAccessor getPropertyAccessor(String propertyName, Object instance) {
        BeanPropertyAccessor<Object> beanPropertyAccessor = this.propertyNameToBeanPropertyAccessorMap.get(propertyName);
        return beanPropertyAccessor == null ? null : new PropertyForArbitraryObject(propertyName, beanPropertyAccessor, instance, this.exceptionHandler);
    }

    @Override
    public Iterable<String> getPropertyNameIterable(Object instance) {
        return this.propertyNameToBeanPropertyAccessorMap.keySet();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> determineFactoryMetaInformation(Object instance) {
        return null;
    }

    static final class PropertyForArbitraryObject
    implements PropertyAccessor {
        private static final long serialVersionUID = 8531632621722929109L;
        private final String propertyName;
        private final BeanPropertyAccessor<Object> beanPropertyAccessor;
        private final Object instance;
        private final ExceptionHandler exceptionHandler;
        private final BeanPropertyAccessor.PropertyAccessType propertyAccessType = BeanPropertyAccessor.PropertyAccessType.PROPERTY;

        public PropertyForArbitraryObject(String propertyName, BeanPropertyAccessor<Object> beanPropertyAccessor, Object instance, ExceptionHandler exceptionHandler) {
            this.propertyName = propertyName;
            this.beanPropertyAccessor = beanPropertyAccessor;
            this.instance = instance;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void setValue(Object value) {
            boolean setPropertyValue = this.beanPropertyAccessor.setPropertyValue(this.instance, value, this.propertyAccessType, this.exceptionHandler);
            Assert.isTrue(setPropertyValue, "Property is not writable");
        }

        @Override
        public Object getValue() {
            return this.beanPropertyAccessor.getPropertyValue(this.instance, this.propertyAccessType, this.exceptionHandler);
        }

        @Override
        public Class<?> getType() {
            return this.beanPropertyAccessor.getDeclaringPropertyType();
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

