/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.Map;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterNumberToString;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;

class InstanceAccessorForArray
implements InstanceAccessor {
    private static final long serialVersionUID = 2333101719267731829L;
    private final Class<Object[]> type;

    InstanceAccessorForArray(Class<?> type) {
        this.type = type;
    }

    @Override
    public PropertyAccessor getPropertyAccessor(final String propertyName, Object instance) {
        final Object[] array = InstanceAccessorForArray.determineArrayInstanceFrom(instance);
        final int index = Integer.valueOf(propertyName);
        return new PropertyAccessor(){
            private static final long serialVersionUID = -3691382969720287591L;

            @Override
            public void setValue(Object value) {
                if (array != null) {
                    array[index] = value;
                }
            }

            @Override
            public Object getValue() {
                return array != null ? array[index] : null;
            }

            @Override
            public Class<?> getType() {
                Object value = this.getValue();
                return value != null ? value.getClass() : null;
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }
        };
    }

    @Override
    public Iterable<String> getPropertyNameIterable(Object instance) {
        Object[] array = InstanceAccessorForArray.determineArrayInstanceFrom(instance);
        Range range = new Range(0, array.length - 1);
        ElementConverterNumberToString elementConverter = new ElementConverterNumberToString();
        return IterableUtils.adapter(range, elementConverter);
    }

    private static Object[] determineArrayInstanceFrom(Object instance) {
        return (Object[])instance;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> determineFactoryMetaInformation(Object instance) {
        int length = ArrayUtils.length(instance);
        Map<String, Object> retmap = MapUtils.builder().put("size", length).buildAs().hashMap();
        return retmap;
    }
}

