/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterNumberToString;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;

class InstanceAccessorForIterable
implements InstanceAccessor {
    private static final long serialVersionUID = -2295601391716506677L;
    private final Class<?> type;

    InstanceAccessorForIterable(Class<?> type) {
        this.type = type;
    }

    @Override
    public PropertyAccessor getPropertyAccessor(final String propertyName, Object instance) {
        final List<Object> list = InstanceAccessorForIterable.determineWrappedListInstanceFrom(instance);
        final List<Object> nativeList = InstanceAccessorForIterable.determineListInstanceFrom(instance);
        final Collection<Object> nativeCollection = InstanceAccessorForIterable.determineCollectionInstanceFrom(instance);
        final int index = Integer.valueOf(propertyName);
        return new PropertyAccessor(){
            private static final long serialVersionUID = 704781840105684736L;

            @Override
            public void setValue(Object value) {
                if (nativeList != null) {
                    ListUtils.set(nativeList, index, value);
                } else if (nativeCollection != null) {
                    nativeCollection.add(value);
                } else {
                    throw new UnsupportedOperationException("Iterable cannot be written since it does not allow to add elements to it");
                }
            }

            @Override
            public Object getValue() {
                return ListUtils.get(list, index);
            }

            @Override
            public Class<?> getType() {
                Object value = this.getValue();
                return value != null ? value.getClass() : null;
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }
        };
    }

    @Override
    public Iterable<String> getPropertyNameIterable(Object instance) {
        int lastIndex = InstanceAccessorForIterable.determineSizeFrom(instance) - 1;
        Range range = new Range(0, lastIndex);
        ElementConverterNumberToString elementConverter = new ElementConverterNumberToString();
        return IterableUtils.adapter(range, elementConverter);
    }

    private static int determineSizeFrom(Object instance) {
        return IterableUtils.size((Iterable)instance);
    }

    private static List<Object> determineListInstanceFrom(Object instance) {
        if (instance instanceof List) {
            return (List)instance;
        }
        return null;
    }

    private static List<Object> determineWrappedListInstanceFrom(Object instance) {
        if (instance instanceof List) {
            return (List)instance;
        }
        return ListUtils.valueOf((Iterable)instance);
    }

    private static Collection<Object> determineCollectionInstanceFrom(Object instance) {
        if (instance instanceof Collection) {
            return (Collection)instance;
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> determineFactoryMetaInformation(Object instance) {
        int size = 0;
        if (instance instanceof Collection) {
            size = CollectionUtils.size((Object)instance);
        } else if (instance instanceof Iterable) {
            size = IterableUtils.size((Iterable)instance);
        }
        Map<String, Object> retmap = MapUtils.builder().put("size", size).buildAs().hashMap();
        return retmap;
    }
}

