/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterNumberToString;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;

class InstanceAccessorForList
implements InstanceAccessor {
    private static final long serialVersionUID = -516323037234035344L;
    private final Class<?> type;

    InstanceAccessorForList(Class<?> type) {
        this.type = type;
    }

    @Override
    public PropertyAccessor getPropertyAccessor(final String propertyName, Object instance) {
        final List<Object> list = InstanceAccessorForList.determineListInstanceFrom(instance);
        final int index = Integer.valueOf(propertyName);
        return new PropertyAccessor(){
            private static final long serialVersionUID = 704781840105684736L;

            @Override
            public void setValue(Object value) {
                ListUtils.set(list, index, value);
            }

            @Override
            public Object getValue() {
                return ListUtils.get(list, index);
            }

            @Override
            public Class<?> getType() {
                Object value = this.getValue();
                return value != null ? value.getClass() : null;
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }
        };
    }

    @Override
    public Iterable<String> getPropertyNameIterable(Object instance) {
        List<Object> list = InstanceAccessorForList.determineListInstanceFrom(instance);
        Range range = new Range(0, list.size() - 1);
        ElementConverterNumberToString elementConverter = new ElementConverterNumberToString();
        return IterableUtils.adapter(range, elementConverter);
    }

    private static List<Object> determineListInstanceFrom(Object instance) {
        return (List)instance;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> determineFactoryMetaInformation(Object instance) {
        int size = 0;
        if (instance instanceof Collection) {
            size = CollectionUtils.size((Object)instance);
        }
        Map<String, Object> retmap = MapUtils.builder().put("size", size).buildAs().hashMap();
        return retmap;
    }
}

