/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.PropertyAccessor;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToString;
import org.omnaest.utils.structure.map.MapUtils;

class InstanceAccessorForMap
implements InstanceAccessor {
    private static final long serialVersionUID = -4549376308631699218L;

    InstanceAccessorForMap() {
    }

    @Override
    public PropertyAccessor getPropertyAccessor(final String propertyName, Object instance) {
        final Map<Object, Object> map = InstanceAccessorForMap.instanceAsMap(instance);
        return new PropertyAccessor(){
            private static final long serialVersionUID = -7943517135842868232L;

            @Override
            public void setValue(Object value) {
                if (map != null) {
                    map.put(propertyName, value);
                }
            }

            @Override
            public Object getValue() {
                Object retval = null;
                if (map != null) {
                    retval = map.get(propertyName);
                }
                return retval;
            }

            @Override
            public Class<?> getType() {
                Class<?> retval = null;
                Object value = this.getValue();
                if (value != null) {
                    retval = value.getClass();
                }
                return retval;
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }
        };
    }

    private static Map<Object, Object> instanceAsMap(Object instance) {
        return instance instanceof Map ? (Map)instance : null;
    }

    @Override
    public Iterable<String> getPropertyNameIterable(Object instance) {
        return instance instanceof Map ? SetUtils.convert(((Map)instance).keySet(), new ElementConverterObjectToString()) : SetUtils.emptySet();
    }

    @Override
    public Class<?> getType() {
        return Map.class;
    }

    @Override
    public Map<String, Object> determineFactoryMetaInformation(Object instance) {
        int size = 0;
        Comparator comparator = null;
        if (instance instanceof Map) {
            size = MapUtils.size((Map)instance);
        }
        if (instance instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)instance;
            comparator = sortedMap.comparator();
        }
        Map<String, Object> retmap = MapUtils.builder().put("comparator", comparator).put("size", size).buildAs().hashMap();
        return retmap;
    }
}

