/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.HashMap;
import java.util.Map;
import org.omnaest.utils.beans.replicator.InstanceAccessor;
import org.omnaest.utils.beans.replicator.InstanceAccessorArbitraryObject;
import org.omnaest.utils.beans.replicator.InstanceAccessorForArray;
import org.omnaest.utils.beans.replicator.InstanceAccessorForIterable;
import org.omnaest.utils.beans.replicator.InstanceAccessorForList;
import org.omnaest.utils.beans.replicator.InstanceAccessorForMap;
import org.omnaest.utils.beans.replicator.InstanceAccessorResolver;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.iterator.IterableUtils;

class InstanceAccessorResolverImpl
implements InstanceAccessorResolver {
    private static final long serialVersionUID = 7646339051909377254L;
    private final Map<Class<?>, InstanceAccessor> typeToInstanceAccessorMap = new HashMap();
    private final ExceptionHandler exceptionHandler;

    InstanceAccessorResolverImpl(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public InstanceAccessor resolveInstanceAccessor(Class<?> type) {
        InstanceAccessor retval = this.typeToInstanceAccessorMap.get(type);
        if (retval == null) {
            retval = Map.class.isAssignableFrom(type) ? new InstanceAccessorForMap() : (ArrayUtils.isArrayType(type) ? new InstanceAccessorForArray(type) : (ListUtils.isListType(type) ? new InstanceAccessorForList(type) : (IterableUtils.isIterableType(type) ? new InstanceAccessorForIterable(type) : new InstanceAccessorArbitraryObject(type, this.exceptionHandler))));
            this.typeToInstanceAccessorMap.put(type, retval);
        }
        return retval;
    }
}

