/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.omnaest.utils.beans.replicator.InstanceCache;

class InstanceCacheImpl
implements InstanceCache {
    private static final long serialVersionUID = 8839858336083004326L;
    private Map<TypeAndInstance, Object> typeAndInstanceToReplicaInstanceMap = new ConcurrentHashMap<TypeAndInstance, Object>();

    InstanceCacheImpl() {
    }

    @Override
    public void addReplicaInstance(Class<?> type, Object instance, Object replicaInstance) {
        if (replicaInstance != null) {
            TypeAndInstance key = new TypeAndInstance(type, instance);
            this.typeAndInstanceToReplicaInstanceMap.put(key, replicaInstance);
        }
    }

    @Override
    public Object getReplicaInstance(Class<?> type, Object instance) {
        TypeAndInstance key = new TypeAndInstance(type, instance);
        return this.typeAndInstanceToReplicaInstanceMap.get(key);
    }

    private static class TypeAndInstance {
        private final Class<?> type;
        private final Object instance;

        public TypeAndInstance(Class<?> type, Object instance) {
            this.type = type;
            this.instance = instance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeAndInstance)) {
                return false;
            }
            TypeAndInstance other = (TypeAndInstance)obj;
            if (this.instance == null ? other.instance != null : this.instance != other.instance) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

