/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;

class Path
implements Serializable {
    private static final long serialVersionUID = -6753433772711288639L;
    private final String[] path;

    Path() {
        this.path = new String[0];
    }

    Path(String canonicalPath) {
        this.path = ListUtils.valueOf(Splitter.on((char)'.').split((CharSequence)canonicalPath)).toArray(new String[0]);
    }

    Path(String[] path) {
        this.path = path;
    }

    Path(Path parentPath, String propertyName) {
        this.path = (String[])ArrayUtils.add((Object[])parentPath.getPath(), (Object)propertyName);
    }

    public String[] getPath() {
        return this.path;
    }

    public int size() {
        return this.path.length;
    }

    public String getCanonicalPath() {
        return Joiner.on((char)'.').join((Object[])this.path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Path [path=");
        builder.append(Arrays.toString(this.path));
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        return Arrays.equals(this.path, other.path);
    }
}

