/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.io.Serializable;
import java.util.Arrays;
import org.omnaest.utils.beans.replicator.TypeAndType;
import org.omnaest.utils.structure.element.converter.ElementConverter;

class Pipe<FROM, TO>
implements Serializable {
    private static final long serialVersionUID = -5157086773922721837L;
    private final Class<FROM> typeFrom;
    private final Class<TO> typeTo;
    private final ElementConverter<Object, Object>[] elementConverters;

    Pipe(Class<FROM> typeFrom, Class<TO> typeTo, ElementConverter<Object, Object>[] elementConverters) {
        this.typeFrom = typeFrom;
        this.typeTo = typeTo;
        this.elementConverters = elementConverters;
    }

    public TO convert(FROM instance) {
        Object retval = instance;
        for (ElementConverter<Object, Object> elementConverter : this.elementConverters) {
            retval = elementConverter.convert(retval);
        }
        return (TO)retval;
    }

    public TypeAndType getTypeAndType() {
        return new TypeAndType(this.typeFrom, this.typeTo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Pipe [typeFrom=");
        builder.append(this.typeFrom);
        builder.append(", typeTo=");
        builder.append(this.typeTo);
        builder.append(", elementConverters=");
        builder.append(Arrays.toString(this.elementConverters));
        builder.append("]");
        return builder.toString();
    }
}

