/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.util.HashSet;
import java.util.Set;
import org.omnaest.utils.beans.replicator.Path;
import org.omnaest.utils.beans.replicator.PreservationAndIgnorationManager;
import org.omnaest.utils.structure.collection.set.SetUtils;

class PreservationAndIgnorationManagerImpl
implements PreservationAndIgnorationManager {
    private static final long serialVersionUID = 353683779213474767L;
    private final Set<Class<?>> typePreservedSet = new HashSet();
    private final Set<Path> pathPreservedSet = new HashSet<Path>();
    private final Set<Class<?>> typeIgnoredSet = new HashSet();
    private final Set<Path> pathIgnoredSet = new HashSet<Path>();
    private int deepnessLevelIgnored = -1;
    private int deepnessLevelPreserved = -1;

    PreservationAndIgnorationManagerImpl() {
    }

    @Override
    public boolean isPreservedType(Class<?> type) {
        return this.typePreservedSet.contains(type);
    }

    @Override
    public void addPreservedType(Class<?> type) {
        if (type != null) {
            this.typePreservedSet.add(type);
        }
    }

    @Override
    public void addAllPreservedTypes(Iterable<? extends Class<?>> typeIterable) {
        SetUtils.addAll(this.typePreservedSet, typeIterable);
    }

    @Override
    public boolean isIgnoredType(Class<?> type) {
        return this.typeIgnoredSet.contains(type);
    }

    @Override
    public void addIgnoredType(Class<?> type) {
        if (type != null) {
            this.typeIgnoredSet.add(type);
        }
    }

    @Override
    public void addAllIgnoredTypes(Iterable<? extends Class<?>> typeIterable) {
        SetUtils.addAll(this.typeIgnoredSet, typeIterable);
    }

    @Override
    public void addPreservedPath(String path) {
        if (path != null) {
            SetUtils.add(this.pathPreservedSet, new Path(path));
        }
    }

    @Override
    public void addIgnoredPath(String path) {
        if (path != null) {
            SetUtils.add(this.pathIgnoredSet, new Path(path));
        }
    }

    @Override
    public boolean isPreservedPath(Path path) {
        boolean retval = this.pathPreservedSet.contains(path);
        return retval |= this.deepnessLevelPreserved >= 0 && path.size() >= this.deepnessLevelPreserved;
    }

    @Override
    public boolean isIgnoredPath(Path subPath) {
        boolean retval = this.deepnessLevelIgnored >= 0 && subPath.size() >= this.deepnessLevelIgnored;
        return retval |= this.pathIgnoredSet.contains(subPath);
    }

    @Override
    public void setIgnoredDeepnessLevel(int deepnessLevel) {
        this.deepnessLevelIgnored = deepnessLevel;
    }

    @Override
    public void setPreservedDeepnessLevel(int deepnessLevel) {
        this.deepnessLevelPreserved = deepnessLevel;
    }
}

