/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.replicator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.replicator.Path;
import org.omnaest.utils.beans.replicator.PropertyNameAndPath;
import org.omnaest.utils.beans.replicator.PropertyNameAndType;
import org.omnaest.utils.beans.replicator.PropertyNameAndTypeAndPath;
import org.omnaest.utils.beans.replicator.TypeAndPath;
import org.omnaest.utils.beans.replicator.TypeToTypeMappingManager;

class TypeToTypeMappingManagerImpl
implements TypeToTypeMappingManager {
    private static final long serialVersionUID = -2633024229759544479L;
    private Map<Class<?>, Class<?>> sourceToTargetTypeMap = new HashMap();
    private Map<TypeAndPath, Class<?>> sourceToTargetTypeAndPathMap = new HashMap();
    private Map<PropertyNameAndType, PropertyNameAndType> sourceToTargetPropertyNameAndTypeMap = new HashMap<PropertyNameAndType, PropertyNameAndType>();
    private Map<PropertyNameAndTypeAndPath, PropertyNameAndType> sourceToTargetPropertyNameAndTypeAndPathMap = new HashMap<PropertyNameAndTypeAndPath, PropertyNameAndType>();
    private Map<String, String> propertyNameToPropertyNameMap = new HashMap<String, String>();
    private Map<PropertyNameAndPath, String> propertyNameAndPathToPropertyNameMap = new HashMap<PropertyNameAndPath, String>();
    private Map<PropertyNameAndTypeAndPath, PropertyNameAndType> cache = new ConcurrentHashMap<PropertyNameAndTypeAndPath, PropertyNameAndType>();

    TypeToTypeMappingManagerImpl() {
    }

    @Override
    public PropertyNameAndType determineRemapping(String propertyName, Class<?> type, Path path) {
        Assert.isNotNull((Object)propertyName, "propertyName must not be null");
        Assert.isNotNull(type, "type must not be null");
        Assert.isNotNull((Object)path, "path must not be null");
        PropertyNameAndType retval = null;
        Serializable key = new PropertyNameAndTypeAndPath(propertyName, type, path);
        retval = this.cache.get(key);
        if (retval == null) {
            key = new PropertyNameAndTypeAndPath(propertyName, type, path);
            retval = this.sourceToTargetPropertyNameAndTypeAndPathMap.get(key);
            if (retval == null) {
                key = new PropertyNameAndType(propertyName, type);
                retval = this.sourceToTargetPropertyNameAndTypeMap.get(key);
            }
            if (retval == null) {
                Class<?> typeTo = null;
                TypeAndPath key2 = new TypeAndPath(path, type);
                typeTo = this.sourceToTargetTypeAndPathMap.get(key2);
                if (typeTo == null) {
                    typeTo = this.sourceToTargetTypeMap.get(type);
                }
                String propertyNameTo = null;
                PropertyNameAndPath key3 = new PropertyNameAndPath(propertyName, path);
                propertyNameTo = this.propertyNameAndPathToPropertyNameMap.get(key3);
                if (propertyNameTo == null) {
                    propertyNameTo = this.propertyNameToPropertyNameMap.get(propertyName);
                }
                if (propertyNameTo != null || typeTo != null) {
                    if (propertyNameTo == null) {
                        propertyNameTo = propertyName;
                    }
                    if (typeTo == null) {
                        typeTo = type;
                    }
                    retval = new PropertyNameAndType(propertyNameTo, typeTo);
                }
            }
            if (retval != null) {
                this.cache.put(new PropertyNameAndTypeAndPath(propertyName, type, path), retval);
            }
        }
        return retval;
    }

    @Override
    public void addTypeMapping(Class<?> typeFrom, Class<?> typeTo) {
        Assert.isNotNull(typeFrom, "typeFrom must not be null");
        Assert.isNotNull(typeTo, "typeTo must not be null");
        this.sourceToTargetTypeMap.put(typeFrom, typeTo);
    }

    @Override
    public void addPropertyNameMapping(String propertyNameFrom, String propertyNameTo) {
        Assert.isNotNull((Object)propertyNameFrom, "propertyNameFrom must not be null");
        Assert.isNotNull((Object)propertyNameTo, "propertyNameTo must not be null");
        this.propertyNameToPropertyNameMap.put(propertyNameFrom, propertyNameTo);
    }

    @Override
    public void addPropertyNameMapping(String path, String propertyNameFrom, String propertyNameTo) {
        Assert.isNotNull((Object)propertyNameFrom, "propertyNameFrom must not be null");
        Assert.isNotNull((Object)propertyNameTo, "propertyNameTo must not be null");
        Assert.isNotNull((Object)path, "path must not be null");
        PropertyNameAndPath key = new PropertyNameAndPath(propertyNameFrom, path);
        String value = propertyNameTo;
        this.propertyNameAndPathToPropertyNameMap.put(key, value);
    }

    @Override
    public void addTypeAndPropertyNameMapping(Class<?> typeFrom, String propertyNameFrom, Class<?> typeTo, String propertyNameTo) {
        Assert.isNotNull(typeFrom, "typeFrom must not be null");
        Assert.isNotNull((Object)propertyNameFrom, "propertyNameFrom must not be null");
        Assert.isNotNull(typeTo, "typeTo must not be null");
        Assert.isNotNull((Object)propertyNameTo, "propertyNameTo must not be null");
        PropertyNameAndType key = new PropertyNameAndType(propertyNameFrom, typeFrom);
        PropertyNameAndType value = new PropertyNameAndType(propertyNameTo, typeTo);
        this.sourceToTargetPropertyNameAndTypeMap.put(key, value);
    }

    @Override
    public void addTypeAndPropertyNameMapping(String path, Class<?> typeFrom, String propertyNameFrom, Class<?> typeTo, String propertyNameTo) {
        Assert.isNotNull(typeFrom, "typeFrom must not be null");
        Assert.isNotNull((Object)propertyNameFrom, "propertyNameFrom must not be null");
        Assert.isNotNull(typeTo, "typeTo must not be null");
        Assert.isNotNull((Object)propertyNameTo, "propertyNameTo must not be null");
        Assert.isNotNull((Object)path, "path must not be null");
        PropertyNameAndTypeAndPath key = new PropertyNameAndTypeAndPath(propertyNameFrom, typeFrom, path);
        PropertyNameAndType value = new PropertyNameAndType(propertyNameTo, typeTo);
        this.sourceToTargetPropertyNameAndTypeAndPathMap.put(key, value);
    }

    @Override
    public void addTypeMappingForPath(String path, Class<?> typeFrom, Class<?> typeTo) {
        Assert.isNotNull((Object)path, "path must not be null");
        Assert.isNotNull(typeFrom, "typeFrom must not be null");
        Assert.isNotNull(typeTo, "typeTo must not be null");
        TypeAndPath key = new TypeAndPath(path, typeFrom);
        Class<?> value = typeTo;
        this.sourceToTargetTypeAndPathMap.put(key, value);
    }
}

