/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.result;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.tuple.Tuple2;

public class BeanPropertyAccessor<B>
implements Serializable {
    private static final long serialVersionUID = 7631705587737553708L;
    private static final PropertyAccessType DEFAULT_PROPERTYACCESSTYPE = PropertyAccessType.PROPERTY;
    protected String propertyName;
    protected transient Field field;
    protected transient Method methodGetter;
    protected transient Method methodSetter;
    protected Class<B> beanType;
    protected PropertyAccessType propertyAccessType;

    public BeanPropertyAccessor(Field field, Method methodGetter, Method methodSetter, String propertyName, Class<B> beanType) {
        this(field, methodGetter, methodSetter, propertyName, beanType, DEFAULT_PROPERTYACCESSTYPE);
    }

    public BeanPropertyAccessor(Field field, Method methodGetter, Method methodSetter, String propertyName, Class<B> beanType, PropertyAccessType propertyAccessType) {
        this.propertyName = propertyName;
        this.field = field;
        this.methodGetter = methodGetter;
        this.methodSetter = methodSetter;
        this.beanType = beanType;
        this.propertyAccessType = propertyAccessType;
    }

    private BeanPropertyAccessor() {
    }

    public boolean copyPropertyValue(B beanSource, B beanDestination) {
        boolean retval = false;
        if (beanDestination != null && beanSource != null && this.hasGetterAndSetter()) {
            try {
                this.methodSetter.invoke(beanDestination, this.methodGetter.invoke(beanSource, new Object[0]));
                retval = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retval;
    }

    public boolean copyPropertyValue(B beanSource, BeanPropertyAccessor<B> beanPropertyAccessorTarget, B beanTarget) {
        boolean retval = false;
        if (beanPropertyAccessorTarget != null) {
            Object value = this.getPropertyValue(beanSource);
            beanPropertyAccessorTarget.setPropertyValue(beanTarget, value);
            retval = true;
        }
        return retval;
    }

    public Class<?> getDeclaringPropertyType(PropertyAccessType ... propertyAccessTypes) {
        Class<?> retval = null;
        if (propertyAccessTypes != null) {
            PropertyAccessType propertyAccessType;
            PropertyAccessType[] arr$ = propertyAccessTypes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retval = this.getDeclaringPropertyType(propertyAccessType = arr$[i$])) == null; ++i$) {
            }
        }
        return retval;
    }

    public Class<?> getDeclaringPropertyType() {
        return this.getDeclaringPropertyType(this.propertyAccessType);
    }

    public Class<?> getDeclaringPropertyType(PropertyAccessType propertyAccessType) {
        Class<?> retval = null;
        if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
            if (this.field != null) {
                retval = this.field.getType();
            }
        } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
            if (this.methodGetter != null) {
                retval = this.methodGetter.getReturnType();
            } else if (this.methodSetter != null) {
                retval = this.methodSetter.getParameterTypes()[0];
            }
        }
        return retval;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.getAnnotation(annotationType, this.propertyAccessType);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType, PropertyAccessType propertyAccessType) {
        Annotation retval = null;
        Map<Class<Annotation>, Annotation> annotationTypeToAnnotationMap = null;
        if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
            if (this.field != null) {
                annotationTypeToAnnotationMap = ReflectionUtils.annotationTypeToAnnotationMap(this.field);
            }
        } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
            if (this.methodGetter != null) {
                annotationTypeToAnnotationMap = ReflectionUtils.annotationTypeToAnnotationMap(this.methodGetter);
            } else if (this.methodSetter != null) {
                annotationTypeToAnnotationMap = ReflectionUtils.annotationTypeToAnnotationMap(this.methodSetter);
            }
        }
        if (annotationTypeToAnnotationMap != null) {
            retval = annotationTypeToAnnotationMap.get(annotationType);
        }
        return (A)retval;
    }

    public Object getPropertyValue(B bean, PropertyAccessType propertyAccessType) {
        ExceptionHandler exceptionHandler = null;
        return this.getPropertyValue(bean, propertyAccessType, exceptionHandler);
    }

    public Object getPropertyValue(B bean, PropertyAccessType ... propertyAccessTypes) {
        ExceptionHandler exceptionHandler = null;
        return this.getPropertyValue(bean, exceptionHandler, propertyAccessTypes);
    }

    public Object getPropertyValue(B bean, ExceptionHandler exceptionHandler, PropertyAccessType ... propertyAccessTypes) {
        Object retval = null;
        if (propertyAccessTypes != null) {
            for (PropertyAccessType propertyAccessType : propertyAccessTypes) {
                Tuple2<Object, Boolean> propertyValueAndSuccess = this.getPropertyValueAndSuccess(bean, propertyAccessType, exceptionHandler);
                if (!propertyValueAndSuccess.getValueSecond().booleanValue()) continue;
                retval = propertyValueAndSuccess.getValueFirst();
                break;
            }
        }
        return retval;
    }

    public Object getPropertyValue(B bean, PropertyAccessType propertyAccessType, ExceptionHandler exceptionHandler) {
        return this.getPropertyValueAndSuccess(bean, propertyAccessType, exceptionHandler).getValueFirst();
    }

    public Tuple2<Object, Boolean> getPropertyValueAndSuccess(B bean, PropertyAccessType propertyAccessType, ExceptionHandler exceptionHandler) {
        boolean success;
        Object retval;
        block10: {
            BeanPropertyAccessor<B> beanPropertyAccessor;
            retval = null;
            success = false;
            BeanPropertyAccessor<B> beanPropertyAccessor2 = beanPropertyAccessor = this.propertyAccessType.equals((Object)propertyAccessType) ? this : this.newBeanPropertyAccessorWithPropertyAccessType(propertyAccessType);
            if (beanPropertyAccessor.isReadable()) {
                try {
                    AccessibleObject accessibleObject = null;
                    if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
                        accessibleObject = beanPropertyAccessor.field;
                    } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
                        accessibleObject = beanPropertyAccessor.methodGetter;
                    }
                    boolean accessible = accessibleObject.isAccessible();
                    if (!accessible) {
                        accessibleObject.setAccessible(true);
                    }
                    if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
                        retval = beanPropertyAccessor.field.get(bean);
                        success = true;
                    } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
                        retval = beanPropertyAccessor.methodGetter.invoke(bean, new Object[0]);
                        success = true;
                    }
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block10;
                    exceptionHandler.handleException(e);
                }
            }
        }
        return new Tuple2<Object, Boolean>(retval, success);
    }

    public Object getPropertyValue(B bean) {
        return this.getPropertyValue(bean, this.propertyAccessType);
    }

    public boolean setPropertyValue(B bean, Object value) {
        return this.setPropertyValue(bean, value, this.propertyAccessType);
    }

    public boolean setPropertyValue(B bean, Object value, PropertyAccessType propertyAccessType) {
        ExceptionHandler exceptionHandler = null;
        return this.setPropertyValue(bean, value, propertyAccessType, exceptionHandler);
    }

    public boolean setPropertyValue(B bean, Object value, PropertyAccessType ... propertyAccessTypes) {
        ExceptionHandler exceptionHandler = null;
        return this.setPropertyValue(bean, value, exceptionHandler, propertyAccessTypes);
    }

    public boolean setPropertyValue(B bean, Object value, ExceptionHandler exceptionHandler, PropertyAccessType ... propertyAccessTypes) {
        boolean retval = false;
        if (propertyAccessTypes != null) {
            PropertyAccessType propertyAccessType;
            PropertyAccessType[] arr$ = propertyAccessTypes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(retval = this.setPropertyValue(bean, value, propertyAccessType = arr$[i$], exceptionHandler)); ++i$) {
            }
        }
        return retval;
    }

    public boolean setPropertyValue(B bean, Object value, PropertyAccessType propertyAccessType, ExceptionHandler exceptionHandler) {
        boolean retval;
        block10: {
            BeanPropertyAccessor<B> beanPropertyAccessor;
            retval = false;
            BeanPropertyAccessor<B> beanPropertyAccessor2 = beanPropertyAccessor = this.propertyAccessType.equals((Object)propertyAccessType) ? this : this.newBeanPropertyAccessorWithPropertyAccessType(propertyAccessType);
            if (beanPropertyAccessor.isWritable() && bean != null) {
                try {
                    AccessibleObject accessibleObject = null;
                    if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
                        accessibleObject = beanPropertyAccessor.field;
                    } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
                        accessibleObject = beanPropertyAccessor.methodSetter;
                    }
                    boolean accessible = accessibleObject.isAccessible();
                    if (!accessible) {
                        accessibleObject.setAccessible(true);
                    }
                    if (PropertyAccessType.FIELD.equals((Object)propertyAccessType)) {
                        beanPropertyAccessor.field.set(bean, value);
                    } else if (PropertyAccessType.PROPERTY.equals((Object)propertyAccessType)) {
                        beanPropertyAccessor.methodSetter.invoke(bean, value);
                    }
                    retval = true;
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block10;
                    exceptionHandler.handleException(e);
                }
            }
        }
        return retval;
    }

    public boolean hasGetterOrSetter() {
        return this.hasGetter() || this.hasSetter();
    }

    public boolean hasGetterAndSetter() {
        return this.hasGetter() && this.hasSetter();
    }

    public boolean isReadAndWritable() {
        return this.isPropertyAccessingByGetterAndSetter() && this.hasGetterAndSetter() || this.isPropertyAccessingByField() && this.hasField();
    }

    public boolean isReadable() {
        return this.isPropertyAccessingByGetterAndSetter() && this.hasGetter() || this.isPropertyAccessingByField() && this.hasField();
    }

    public boolean isWritable() {
        return this.isPropertyAccessingByGetterAndSetter() && this.hasSetter() || this.isPropertyAccessingByField() && this.hasField();
    }

    private boolean isPropertyAccessingByField() {
        return PropertyAccessType.FIELD.equals((Object)this.propertyAccessType);
    }

    private boolean isPropertyAccessingByGetterAndSetter() {
        return DEFAULT_PROPERTYACCESSTYPE.equals((Object)this.propertyAccessType);
    }

    public boolean hasField() {
        return this.field != null;
    }

    public boolean hasGetter() {
        return this.methodGetter != null;
    }

    public boolean hasSetter() {
        return this.methodSetter != null;
    }

    public static <B> BeanPropertyAccessor<B> merge(BeanPropertyAccessor<B> beanPropertyAccessorA, BeanPropertyAccessor<B> beanPropertyAccessorB) {
        BeanPropertyAccessor<B> retval = null;
        if (beanPropertyAccessorA != null && beanPropertyAccessorB != null && StringUtils.equals((CharSequence)beanPropertyAccessorA.propertyName, (CharSequence)beanPropertyAccessorB.propertyName) && beanPropertyAccessorA.beanType != null && beanPropertyAccessorA.beanType.equals(beanPropertyAccessorB.beanType)) {
            String propertyname = beanPropertyAccessorA.propertyName != null ? beanPropertyAccessorA.propertyName : beanPropertyAccessorB.propertyName;
            Class<B> beanClass = beanPropertyAccessorA.beanType != null ? beanPropertyAccessorA.beanType : beanPropertyAccessorB.beanType;
            Field field = beanPropertyAccessorA.field != null ? beanPropertyAccessorA.field : beanPropertyAccessorB.field;
            Method methodGetter = beanPropertyAccessorA.methodGetter != null ? beanPropertyAccessorA.methodGetter : beanPropertyAccessorB.methodGetter;
            Method methodSetter = beanPropertyAccessorA.methodSetter != null ? beanPropertyAccessorA.methodSetter : beanPropertyAccessorB.methodSetter;
            retval = new BeanPropertyAccessor<B>(field, methodGetter, methodSetter, propertyname, beanClass);
        }
        return retval;
    }

    public Class<B> getBeanClass() {
        return this.beanType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethodGetter() {
        return this.methodGetter;
    }

    public Method getMethodSetter() {
        return this.methodSetter;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BeanPropertyAccessor [propertyName=");
        builder.append(this.propertyName);
        builder.append(", field=");
        builder.append(this.field);
        builder.append(", methodGetter=");
        builder.append(this.methodGetter);
        builder.append(", methodSetter=");
        builder.append(this.methodSetter);
        builder.append(", beanClass=");
        builder.append(this.beanType);
        builder.append(", propertyAccessType=");
        builder.append((Object)this.propertyAccessType);
        builder.append("]");
        return builder.toString();
    }

    public BeanPropertyAccessor<B> newBeanPropertyAccessorWithPropertyAccessType(PropertyAccessType propertyAccessType) {
        return new BeanPropertyAccessor<B>(this.field, this.methodGetter, this.methodSetter, this.propertyName, this.beanType, ObjectUtils.defaultIfNull(propertyAccessType, DEFAULT_PROPERTYACCESSTYPE));
    }

    public Object readResolve() throws ObjectStreamException {
        return BeanUtils.beanPropertyAccessor(this.beanType, this.propertyName).newBeanPropertyAccessorWithPropertyAccessType(this.propertyAccessType);
    }

    public static enum PropertyAccessType {
        FIELD,
        PROPERTY;

    }
}

