/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.cache;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.omnaest.utils.cache.Cache;
import org.omnaest.utils.cache.CacheAbstract;
import org.omnaest.utils.cache.SynchronizedWeakReferenceCache;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.structure.element.ElementHolder;

public class ConcurrentWeakReferenceCache<K, V>
extends CacheAbstract<K, V> {
    private static final long serialVersionUID = -3600058653640214269L;
    private final List<Cache<K, V>> cacheList;
    private final int numberOfSegments;
    private final AtomicLong currentSegmentCounter = new AtomicLong();

    public ConcurrentWeakReferenceCache() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ConcurrentWeakReferenceCache(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
        this.cacheList = ConcurrentWeakReferenceCache.newCacheList(numberOfSegments);
    }

    private static <K, V> List<Cache<K, V>> newCacheList(int numberOfSegments) {
        CopyOnWriteArrayList<Cache<K, V>> retlist = new CopyOnWriteArrayList<Cache<K, V>>();
        for (int ii = 0; ii < numberOfSegments; ++ii) {
            retlist.add(new SynchronizedWeakReferenceCache());
        }
        return retlist;
    }

    @Override
    public int size() {
        return this.getCache().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCache().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getCache().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getCache().get(key);
    }

    @Override
    public V put(final K key, final V value) {
        final ElementHolder retval = new ElementHolder();
        Operation operation = new Operation<Void, Cache<K, V>>(){

            @Override
            public Void execute(Cache<K, V> parameter) {
                retval.setElement(parameter.put(key, value));
                return null;
            }
        };
        this.executeOnAllCacheSegments(operation);
        return (V)retval.getElement();
    }

    @Override
    public V remove(final Object key) {
        final ElementHolder retval = new ElementHolder();
        Operation operation = new Operation<Void, Cache<K, V>>(){

            @Override
            public Void execute(Cache<K, V> parameter) {
                retval.setElement(parameter.remove(key));
                return null;
            }
        };
        this.executeOnAllCacheSegments(operation);
        return (V)retval.getElement();
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> m) {
        Operation operation = new Operation<Void, Cache<K, V>>(){

            @Override
            public Void execute(Cache<K, V> parameter) {
                parameter.putAll(m);
                return null;
            }
        };
        this.executeOnAllCacheSegments(operation);
    }

    @Override
    public void clear() {
        Operation operation = new Operation<Void, Cache<K, V>>(){

            @Override
            public Void execute(Cache<K, V> parameter) {
                parameter.clear();
                return null;
            }
        };
        this.executeOnAllCacheSegments(operation);
    }

    @Override
    public Set<K> keySet() {
        return this.getCache().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getCache().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getCache().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.getCache().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getCache().hashCode();
    }

    private void executeOnAllCacheSegments(Operation<Void, Cache<K, V>> operation) {
        for (Cache<K, V> cache : this.cacheList) {
            operation.execute(cache);
        }
    }

    private Cache<K, V> getCache() {
        int numberOfSegments = this.numberOfSegments;
        int index = numberOfSegments - 1 - Math.abs((int)this.currentSegmentCounter.getAndIncrement()) % numberOfSegments;
        return this.cacheList.get(index);
    }
}

