/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.omnaest.utils.cache.CacheAbstract;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;

public class SynchronizedWeakReferenceCache<K, V>
extends CacheAbstract<K, V> {
    private static final long serialVersionUID = -3985243797516127152L;
    private final Map<K, V> map = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableSet(SetUtils.valueOf(this.map.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableCollection(ListUtils.valueOf(this.map.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return Collections.unmodifiableSet(SetUtils.valueOf(this.map.entrySet()));
        }
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }
}

