/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.codec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.codec.Codec;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;

class EncoderAndDecoderAlphanumericTokens
implements Codec.EncoderAndDecoder<String, String> {
    private static final String CHARSET_UTF_8 = "utf-8";
    private static final int INTERVAL = 3;
    private static final String ALPHA_LETTER_REGEX = "[a-zA-Z]";

    EncoderAndDecoderAlphanumericTokens() {
    }

    @Override
    public String encode(String source) {
        StringBuffer stringBuffer = new StringBuffer();
        if (source != null) {
            Pattern pattern = Pattern.compile(ALPHA_LETTER_REGEX);
            int length = source.length();
            for (int ii = 0; ii < length; ++ii) {
                String token = source.substring(ii, ii + 1);
                Matcher matcher = pattern.matcher(String.valueOf(token));
                if (matcher.matches()) {
                    stringBuffer.append(token);
                    continue;
                }
                try {
                    byte[] bytes;
                    for (byte byteToken : bytes = token.getBytes(CHARSET_UTF_8)) {
                        stringBuffer.append(String.format("%03d", byteToken - -128));
                    }
                    continue;
                }
                catch (Exception e) {
                    Assert.fails(e);
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String decode(String source) {
        StringBuilder stringBuilder = new StringBuilder();
        if (source != null) {
            ElementConverter<String, Byte> elementConverterTokenToByte = new ElementConverter<String, Byte>(){

                @Override
                public Byte convert(String element) {
                    short convert = Short.valueOf(element);
                    return (byte)(convert + -128);
                }
            };
            Pattern pattern = Pattern.compile("([a-zA-Z]+)|([0-9]+)");
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                String groupAlphaLetters = matcher.group(1);
                String groupNumbers = matcher.group(2);
                if (StringUtils.isNotBlank((CharSequence)groupAlphaLetters)) {
                    stringBuilder.append(groupAlphaLetters);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)groupNumbers)) {
                    try {
                        Assert.isTrue(groupNumbers.length() % 3 == 0, "Decoding encountered an numeric group with illegal length. The length must be a multiple of 3");
                        String[] numberTokens = org.omnaest.utils.strings.StringUtils.splitByInterval(groupNumbers, 3);
                        byte[] byteTokens = org.apache.commons.lang3.ArrayUtils.toPrimitive((Byte[])ArrayUtils.convertArray(numberTokens, new Byte[numberTokens.length], elementConverterTokenToByte));
                        String text = new String(byteTokens, CHARSET_UTF_8);
                        stringBuilder.append(text);
                    }
                    catch (Exception e) {
                        Assert.fails(e);
                    }
                    continue;
                }
                Assert.fails("Decoding encountered an illegal character group: " + matcher.group());
            }
        }
        return stringBuilder.toString();
    }
}

