/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.codec;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.codec.Codec;
import org.omnaest.utils.structure.map.MapUtils;

class EncoderAndDecoderEscaping
implements Codec.EncoderAndDecoder<String, String> {
    private final Map<String, String> encodedCharacterToEscapeSequenceMap;
    private final Map<String, String> escapeSequenceToEncodedCharacterMap;

    EncoderAndDecoderEscaping(String escapeCharacter, String[] encodedCharacters) {
        Assert.isNotNull((Object)escapeCharacter, "escapeCharacter must not be null");
        Assert.isNotNull((Object)encodedCharacters, "encodedCharacters must not be null");
        Assert.isFalse(Pattern.matches(".*[0-9].*", Arrays.deepToString(encodedCharacters)), "encodedCharacters must not contain any number");
        LinkedHashMap<String, String> encodedCharacterToEscapeSequenceMap = new LinkedHashMap<String, String>();
        String format = "%0" + (int)Math.ceil(Math.log10(encodedCharacters.length + 1)) + "d";
        int counter = 0;
        for (String encodedCharacter : (String[])ArrayUtils.addAll((Object[])new String[]{escapeCharacter}, (Object[])encodedCharacters)) {
            String escapeSequence = escapeCharacter + String.format(format, counter);
            encodedCharacterToEscapeSequenceMap.put(encodedCharacter, escapeSequence);
            ++counter;
        }
        this.encodedCharacterToEscapeSequenceMap = ImmutableMap.copyOf(encodedCharacterToEscapeSequenceMap);
        this.escapeSequenceToEncodedCharacterMap = ImmutableMap.copyOf(MapUtils.invertedBidirectionalMap(encodedCharacterToEscapeSequenceMap));
    }

    @Override
    public String encode(String source) {
        String retval = source;
        if (retval != null) {
            for (String encodedCharacter : this.encodedCharacterToEscapeSequenceMap.keySet()) {
                String escapeSequence = this.encodedCharacterToEscapeSequenceMap.get(encodedCharacter);
                retval = retval.replaceAll(Pattern.quote(encodedCharacter), Matcher.quoteReplacement(escapeSequence));
            }
        }
        return retval;
    }

    @Override
    public String decode(String source) {
        String retval = source;
        if (retval != null) {
            for (String escapeSequence : this.escapeSequenceToEncodedCharacterMap.keySet()) {
                String encodedCharacter = this.escapeSequenceToEncodedCharacterMap.get(escapeSequence);
                retval = retval.replaceAll(Pattern.quote(escapeSequence), Matcher.quoteReplacement(encodedCharacter));
            }
        }
        return retval;
    }
}

