/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.dispatcher;

import java.io.Serializable;
import java.util.List;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.operation.special.OperationVoid;
import org.omnaest.utils.structure.element.ObjectUtils;

public abstract class DispatcherAbstract<T>
implements Serializable {
    private static final long serialVersionUID = 392437202904888843L;
    protected final List<T> instanceList;
    protected ExceptionHandler exceptionHandler = new ExceptionHandlerIgnoring();

    public DispatcherAbstract(List<T> instanceList) {
        this.instanceList = instanceList;
    }

    public void executeOnAllInstances(OperationVoid<T> operation) {
        if (operation != null) {
            for (T instance : this.instanceList) {
                try {
                    operation.execute(instance);
                }
                catch (Exception e) {
                    this.exceptionHandler.handleException(e);
                }
            }
        }
    }

    public DispatcherAbstract<T> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = ObjectUtils.defaultIfNull(exceptionHandler, new ExceptionHandlerIgnoring());
        return this;
    }
}

