/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.dispatcher;

import java.lang.reflect.Method;
import java.util.List;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;
import org.omnaest.utils.structure.element.ObjectUtils;

public class ProxyDispatcherFactory<T> {
    private final StubCreator<T> stubCreator;
    private ExceptionHandler exceptionHandler = new ExceptionHandlerIgnoring();

    public ProxyDispatcherFactory(Class<? extends T> type) {
        this.stubCreator = new StubCreator<T>(type);
    }

    public T newDispatcher(final List<? extends T> instanceList) {
        MethodInvocationHandler methodInvocationHandler = new MethodInvocationHandler(){

            @Override
            public Object handle(MethodCallCapture methodCallCapture) throws Throwable {
                for (Object instance : instanceList) {
                    try {
                        Method method = methodCallCapture.getMethod();
                        method.invoke(instance, methodCallCapture.getArguments());
                    }
                    catch (Exception e) {
                        ProxyDispatcherFactory.this.exceptionHandler.handleException(e);
                    }
                }
                return null;
            }
        };
        return this.stubCreator.build(methodInvocationHandler);
    }

    public ProxyDispatcherFactory<T> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = ObjectUtils.defaultIfNull(exceptionHandler, new ExceptionHandlerIgnoring());
        return this;
    }
}

