/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.download;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.omnaest.utils.download.DownloadManager;
import org.omnaest.utils.time.DurationCapture;

public class DownloadConnection
implements Runnable {
    private URL url = null;
    private String authenticationUser = null;
    private String authenticationPassword = null;
    private byte[] content = null;
    private DurationCapture timeDuration = DurationCapture.newInstance();
    private URLConnection urlConnection = null;
    private long estimatedByteSize = 0L;
    private long currentlyLoadedBytes = 0L;
    private String contentEncoding = null;
    private String contentType = null;
    private long timeExpired = 0L;
    private DownloadManager downloadManager = null;
    private Thread thread = null;
    private boolean abortDownload = false;
    private String standardEncoding = "utf-8";
    private String usedStringEncoding = null;
    private ArrayList<Exception> exceptionList = new ArrayList(0);
    private DownloadMonitor downloadMonitor = null;

    public DownloadConnection setUrl(URL url) {
        this.url = url;
        return this;
    }

    @Override
    public void run() {
        this.download();
        this.thread = null;
    }

    public DownloadConnection threadedDownload() {
        this.thread = new Thread(this);
        if (this.downloadManager != null) {
            this.downloadManager.startThreadPooled(this.thread);
        } else {
            this.thread.start();
        }
        return this;
    }

    public DownloadConnection threadedDownload(URL url) {
        DownloadConnection retval = null;
        if (url != null) {
            this.setUrl(url);
            retval = this.threadedDownload();
        }
        return retval;
    }

    public void abortDownload() {
        this.abortDownload = true;
    }

    public boolean isAlive() {
        boolean retval = false;
        if (this.thread != null) {
            retval = true;
        }
        return retval;
    }

    public int processStatePercentage() {
        int retval = 0;
        if (this.estimatedByteSize > 0L) {
            retval = Math.round(this.currentlyLoadedBytes * 100L / this.estimatedByteSize);
        }
        return retval;
    }

    public DownloadConnection download(URL url) {
        this.setUrl(url);
        this.download();
        return this;
    }

    public DownloadConnection download() {
        if (this.url != null && this.openConnection()) {
            this.prepareDownload();
            this.downloadContent();
            this.closeConnection();
        }
        return this;
    }

    public int getHTTPStatusCode() {
        int retval = -1;
        if (this.urlConnection != null && this.urlConnection instanceof HttpURLConnection) {
            try {
                retval = ((HttpURLConnection)this.urlConnection).getResponseCode();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    private void prepareDownload() {
        this.timeDuration.startTimeMeasurement("prepareDownload");
        this.estimatedByteSize = this.urlConnection.getContentLength();
        this.contentEncoding = this.urlConnection.getContentEncoding();
        this.contentType = this.urlConnection.getContentType();
        this.timeDuration.stopTimeMeasurement("prepareDownload");
    }

    private synchronized boolean openConnection() {
        this.timeDuration.startTimeMeasurement("openConnection");
        this.exceptionList.clear();
        this.abortDownload = false;
        boolean retval = false;
        try {
            this.urlConnection = null;
            this.urlConnection = this.url.openConnection();
            if (this.url.getProtocol().toLowerCase().matches("http?")) {
                HttpURLConnection huc = (HttpURLConnection)this.urlConnection;
                huc.setInstanceFollowRedirects(true);
                huc.setDefaultUseCaches(true);
                if (this.authenticationUser != null && this.authenticationPassword != null) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(DownloadConnection.this.authenticationUser, DownloadConnection.this.authenticationPassword.toCharArray());
                        }
                    });
                }
                huc.connect();
                this.urlConnection = huc;
            }
            retval = true;
        }
        catch (IOException e) {
            this.exceptionList.add(e);
            e.printStackTrace();
            this.urlConnection = null;
        }
        this.timeDuration.stopTimeMeasurement("openConnection");
        return retval;
    }

    private void downloadContent() {
        this.timeDuration.startTimeMeasurement("downloadContent");
        try {
            InputStream is = this.urlConnection.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = 0;
            this.currentlyLoadedBytes = 0L;
            this.downloadMonitoring(this.processStatePercentage());
            while ((readByte = is.read()) >= 0 && !this.abortDownload) {
                bos.write(readByte);
                ++this.currentlyLoadedBytes;
                this.downloadMonitoring(this.processStatePercentage());
            }
            is.close();
            bos.close();
            this.content = bos.toByteArray();
            if (this.abortDownload) {
                this.exceptionList.add(new Exception("Download aborted by wish."));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.exceptionList.add(e);
        }
        this.timeDuration.stopTimeMeasurement("downloadContent");
    }

    private void downloadMonitoring(int processState) {
        if (this.downloadMonitor != null) {
            this.downloadMonitor.monitoring(processState);
        }
    }

    private void closeConnection() {
        this.timeDuration.startTimeMeasurement("closeConnection");
        if (this.url.getProtocol().toLowerCase().matches("http?")) {
            HttpURLConnection huc = (HttpURLConnection)this.urlConnection;
            this.url = huc.getURL();
            huc.disconnect();
        }
        if (this.estimatedByteSize > 0L && (long)this.content.length != this.estimatedByteSize) {
            this.exceptionList.add(new IOException());
        }
        this.timeDuration.stopTimeMeasurement("closeConnection");
        this.timeExpired = this.timeDuration.stopTimeMeasurement().getDurationInMilliseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentAsBytes() {
        byte[] byArray = this.content;
        synchronized (this.content) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.content;
        }
    }

    public String getContentAsString() {
        String retval = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
        InputStreamReader isr = null;
        if (this.contentEncoding != null && !this.contentEncoding.trim().equals("")) {
            try {
                isr = new InputStreamReader((InputStream)bais, this.contentEncoding);
                this.usedStringEncoding = this.contentEncoding;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (isr == null && this.standardEncoding != null) {
            try {
                isr = new InputStreamReader((InputStream)bais, this.standardEncoding);
                this.usedStringEncoding = this.standardEncoding;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (isr == null) {
            isr = new InputStreamReader(bais);
            this.usedStringEncoding = System.getProperty("file.encoding");
        }
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            boolean firstline = true;
            while ((line = br.readLine()) != null) {
                if (!firstline) {
                    sb.append("\n");
                }
                sb.append(line);
                firstline = false;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        retval = sb.toString();
        return retval;
    }

    public boolean isDownloadSuccessful() {
        boolean retval = false;
        if (this.exceptionList != null && this.exceptionList.size() == 0) {
            retval = true;
        }
        return retval;
    }

    public boolean saveContentToFile(File file) {
        boolean retval = false;
        try {
            if (this.content != null) {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(this.content);
                fos.close();
                retval = true;
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    public long getContentEstimatedSize() {
        return this.estimatedByteSize;
    }

    public long getContentCurrentSize() {
        return this.currentlyLoadedBytes;
    }

    public long getContentSize() {
        long retval = -1L;
        if (!this.isAlive() && this.content != null) {
            retval = this.content.length;
        }
        return retval;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    public void setDownloadManager(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getTimeExpired() {
        long retval = this.timeExpired;
        if (retval == 0L) {
            retval = this.timeDuration.getInterimTimeInMilliseconds();
        }
        return retval;
    }

    public long getDownloadSpeed() {
        long retval = 0L;
        long timeExpired = this.getTimeExpired();
        if (timeExpired > 0L) {
            retval = Math.round(this.currentlyLoadedBytes * 1000L / (1024L * this.getTimeExpired()));
        }
        return retval;
    }

    public String getStandardEncoding() {
        return this.standardEncoding;
    }

    public void setStandardEncoding(String standardEncoding) {
        this.standardEncoding = standardEncoding;
    }

    public String getUsedStringEncoding() {
        return this.usedStringEncoding;
    }

    public void setUsedStringEncoding(String usedStringEncoding) {
        this.usedStringEncoding = usedStringEncoding;
    }

    public URL getUrl() {
        return this.url;
    }

    public DownloadConnection setDownloadMonitor(DownloadMonitor downloadMonitor) {
        this.downloadMonitor = downloadMonitor;
        return this;
    }

    public static interface DownloadMonitor {
        public void monitoring(int var1);
    }
}

