/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.download;

import java.util.ArrayList;
import org.omnaest.utils.download.DownloadConnection;

public class DownloadManager
implements Runnable {
    private static volatile DownloadManager downloadMangerInstance = null;
    private ArrayList<Thread> threadPoolAspirantList = new ArrayList(0);
    private ArrayList<Thread> threadPoolActiveList = new ArrayList(0);
    private static final int checkForNewThreadsTimeInterval = 1000;
    private static int maximalActiveThreadsAllowedCount = 10;
    private Thread threadPoolManager = null;

    private DownloadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadManager getInstance() {
        DownloadManager retdm = null;
        try {
            if (downloadMangerInstance != null) return retdm;
            DownloadManager dm = new DownloadManager();
            Class<DownloadManager> clazz = DownloadManager.class;
            synchronized (DownloadManager.class) {
                if (downloadMangerInstance != null) return retdm;
                downloadMangerInstance = dm;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return retdm;
            }
        }
        finally {
            retdm = downloadMangerInstance;
        }
    }

    public DownloadConnection getDownloadConnection() {
        DownloadConnection retdc = new DownloadConnection();
        retdc.setDownloadManager(this);
        return retdc;
    }

    protected void startThreadPooled(Thread thread) {
        this.threadPoolAspirantList.add(thread);
        this.startThreadPoolManager();
    }

    private void startThreadPoolManager() {
        if (this.threadPoolManager == null) {
            this.threadPoolManager = new Thread(this);
            this.threadPoolManager.start();
        }
    }

    @Override
    public void run() {
        while (this.threadPoolAspirantList.size() > 0 || this.threadPoolActiveList.size() > 0) {
            ArrayList<Thread> removeThreadList = new ArrayList<Thread>(0);
            for (Thread iThread : this.threadPoolActiveList) {
                if (iThread.isAlive()) continue;
                removeThreadList.add(iThread);
            }
            for (Thread iRemoveThread : removeThreadList) {
                this.threadPoolActiveList.remove(iRemoveThread);
            }
            if (this.threadPoolActiveList.size() < maximalActiveThreadsAllowedCount && this.threadPoolAspirantList.size() > 0) {
                Thread thread = this.threadPoolAspirantList.get(0);
                this.threadPoolActiveList.add(thread);
                this.threadPoolAspirantList.remove(thread);
                thread.start();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadPoolManager = null;
    }
}

