/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.download;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class URIHelper {
    public static URI createURI(String scheme, String host, String path, String ... queryParameters) {
        URI uri = null;
        try {
            uri = new URI(scheme, host, path.startsWith("/") ? path : "/" + path, StringUtils.join((Object[])queryParameters, (String)"&"), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return uri;
    }

    public static URI createUri(String location) {
        URI retval = null;
        if (location != null) {
            try {
                retval = new URI(location);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static URI createUri(URI baseAddress, String relativePath) {
        URI retval = null;
        if (baseAddress != null && relativePath != null) {
            try {
                String baseAddressAsString = baseAddress.toString();
                if (!baseAddressAsString.endsWith("/")) {
                    baseAddress = new URI(baseAddress.toString() + "/");
                }
                relativePath = StringUtils.removeStart((String)relativePath, (String)"/");
                retval = baseAddress.normalize().resolve(relativePath).normalize();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static URL getURLfromURI(URI uri) {
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }
}

