/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.download;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.omnaest.utils.download.URIHelper;
import org.omnaest.utils.structure.map.MapUtils;

public class URLHelper {
    public static URL createURL(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static URL createUrl(String scheme, String host, String path, Map<String, String> queryMap) {
        URL retval = null;
        try {
            List<String> queryList = MapUtils.toList(queryMap, new MapUtils.MapEntryToElementConverter<String, String, String>(){

                @Override
                public String convert(Map.Entry<String, String> entry) {
                    return entry.getKey() + "=" + entry.getValue();
                }
            });
            URI uri = URIHelper.createURI(scheme, host, path, queryList.toArray(new String[0]));
            retval = uri.toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        return retval;
    }
}

