/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.events.concrete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omnaest.utils.events.EventListener;
import org.omnaest.utils.events.EventListenerRegistration;
import org.omnaest.utils.events.EventManager;
import org.omnaest.utils.events.EventManagerConnector;
import org.omnaest.utils.events.adapter.EventListenerAdapter;
import org.omnaest.utils.events.event.EventResults;

public class EventManagerConnectorImpl<EVENT, RESULT>
implements EventManagerConnector<EVENT, RESULT> {
    private static final long serialVersionUID = 6714239925791970079L;
    protected EventManager<EVENT, RESULT> eventManager = null;
    protected Map<EventListenerRegistration<?, ?>, EventListener<?, ?>> connectedListenerRegistrationToListenerMap = new HashMap();

    public EventManagerConnectorImpl(EventManager<EVENT, RESULT> eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public EventManagerConnector<EVENT, RESULT> disconnectFrom(EventManager<EVENT, RESULT> eventManager) {
        if (eventManager != null) {
            this.disconnectFrom(eventManager.getEventListenerRegistration());
        }
        return this;
    }

    @Override
    public EventManagerConnector<EVENT, RESULT> disconnectFrom(EventListenerRegistration eventListenerRegistration) {
        if (eventListenerRegistration != null && this.connectedListenerRegistrationToListenerMap.containsKey(eventListenerRegistration)) {
            EventListener<?, ?> eventListener = this.connectedListenerRegistrationToListenerMap.get(eventListenerRegistration);
            eventListenerRegistration.removeEventListener(eventListener);
            this.connectedListenerRegistrationToListenerMap.remove(eventListenerRegistration);
        }
        return this;
    }

    @Override
    public EventManagerConnector<EVENT, RESULT> listenTo(EventListenerRegistration<EVENT, RESULT> eventListenerRegistration) {
        EventListenerAdapter listenerAdapter = new EventListenerAdapter<EVENT, RESULT, EVENT, RESULT>(){

            @Override
            public List<EVENT> adaptEvent(EVENT otherParameter) {
                return Arrays.asList(otherParameter);
            }

            @Override
            public List<RESULT> adaptResult(RESULT returninfo) {
                return Arrays.asList(returninfo);
            }
        };
        return this.listenTo(eventListenerRegistration, listenerAdapter);
    }

    @Override
    public <OTHER_EVENT, OTHER_RESULT> EventManagerConnector<EVENT, RESULT> listenTo(EventListenerRegistration<OTHER_EVENT, OTHER_RESULT> eventListenerRegistration, final EventListenerAdapter<OTHER_EVENT, OTHER_RESULT, EVENT, RESULT> eventListenerAdapter) {
        if (eventListenerRegistration != null && eventListenerAdapter != null && !this.connectedListenerRegistrationToListenerMap.containsKey(eventListenerRegistration)) {
            EventListener listener = new EventListener<OTHER_EVENT, OTHER_RESULT>(){
                private static final long serialVersionUID = -100666254531161206L;

                @Override
                public List<OTHER_RESULT> handleEvent(OTHER_EVENT otherEvent) {
                    ArrayList otherResultList = new ArrayList();
                    List eventList = eventListenerAdapter.adaptEvent(otherEvent);
                    ArrayList resultList = new ArrayList();
                    if (eventList != null) {
                        for (Object event : eventList) {
                            EventResults singleResultList = EventManagerConnectorImpl.this.eventManager.fireEvent(event);
                            if (singleResultList == null) continue;
                            resultList.addAll(singleResultList.getResultList());
                        }
                    }
                    for (Object result : resultList) {
                        List singleOtherResult = eventListenerAdapter.adaptResult(result);
                        if (singleOtherResult == null) continue;
                        otherResultList.addAll(singleOtherResult);
                    }
                    return otherResultList;
                }
            };
            eventListenerRegistration.addEventListener(listener);
            this.connectedListenerRegistrationToListenerMap.put(eventListenerRegistration, listener);
        }
        return this;
    }

    @Override
    public EventManagerConnector<EVENT, RESULT> listenTo(EventManager<EVENT, RESULT> listenerManager) {
        return this.listenTo(listenerManager.getEventListenerRegistration());
    }

    @Override
    public <OTHER_EVENT, OTHER_RESULT> EventManagerConnector<EVENT, RESULT> listenTo(EventManager<OTHER_EVENT, OTHER_RESULT> listenerManager, EventListenerAdapter<OTHER_EVENT, OTHER_RESULT, EVENT, RESULT> listenerAdapter) {
        if (listenerManager != null) {
            this.listenTo(listenerManager.getEventListenerRegistration(), listenerAdapter);
        }
        return this;
    }
}

