/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.events.exception;

import java.util.LinkedHashSet;
import java.util.Set;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.operation.special.OperationIntrinsic;

public class ExceptionHandlerManager {
    protected final ExceptionHandler dispatchingExceptionHandler = new DispatchingExceptionHandler();
    protected final ExceptionHandler dispatchingExceptionHandlerRethrowingExceptions;
    private volatile ExceptionHandler exceptionHandler = this.dispatchingExceptionHandlerRethrowingExceptions = new DispatchingExceptionHandlerRethrowingExceptions();
    protected final Set<ExceptionHandler> exceptionHandlerSet = new LinkedHashSet<ExceptionHandler>();
    protected final ExceptionHandlerRegistration exceptionHandlerRegistration = new ExceptionHandlerRegistration();

    public ExceptionHandlerRegistration getExceptionHandlerRegistration() {
        return this.exceptionHandlerRegistration;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ExceptionHandlerManager clearExceptionHandlers() {
        this.exceptionHandlerSet.clear();
        return this;
    }

    public <R, P> ExceptionHandlerManager executeOperationAndHandleAnyException(OperationIntrinsic operationIntrinsic) {
        if (operationIntrinsic != null) {
            try {
                operationIntrinsic.execute();
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException(e);
            }
        }
        return this;
    }

    public <R, P> R executeOperationAndHandleAnyException(Operation<R, P> operation, P parameter) {
        R retval = null;
        if (operation != null) {
            try {
                retval = operation.execute(parameter);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException(e);
            }
        }
        return retval;
    }

    public ExceptionHandlerManager setRethrowingExceptionsFromExceptionHandler(boolean isRethrowingExceptionsFromExceptionHandler) {
        this.exceptionHandler = isRethrowingExceptionsFromExceptionHandler ? this.dispatchingExceptionHandlerRethrowingExceptions : this.dispatchingExceptionHandler;
        return this;
    }

    public class ExceptionHandlerRegistration {
        public ExceptionHandlerRegistration registerExceptionHandler(ExceptionHandler exceptionHandler) {
            Assert.isNotNull((Object)exceptionHandler, "ExceptionHandler must not be null");
            ExceptionHandlerManager.this.exceptionHandlerSet.add(exceptionHandler);
            return this;
        }

        public ExceptionHandlerRegistration unregisterExceptionHandler(ExceptionHandler exceptionHandler) {
            Assert.isNotNull((Object)exceptionHandler, "ExceptionHandler must not be null");
            ExceptionHandlerManager.this.exceptionHandlerSet.remove(exceptionHandler);
            return this;
        }
    }

    protected class DispatchingExceptionHandlerRethrowingExceptions
    implements ExceptionHandler {
        protected DispatchingExceptionHandlerRethrowingExceptions() {
        }

        @Override
        public void handleException(Exception e) {
            for (ExceptionHandler exceptionHandler : ExceptionHandlerManager.this.exceptionHandlerSet) {
                try {
                    exceptionHandler.handleException(e);
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    protected class DispatchingExceptionHandler
    implements ExceptionHandler {
        protected DispatchingExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            for (ExceptionHandler exceptionHandler : ExceptionHandlerManager.this.exceptionHandlerSet) {
                try {
                    exceptionHandler.handleException(e);
                }
                catch (Exception e2) {}
            }
        }
    }
}

