/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.battery;

import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.operation.OperationFactory;
import org.omnaest.utils.operation.decorator.OperationDecoratorReentrantLock;

public abstract class OperationBattery<RESULT, PARAMETER>
implements Operation<RESULT, PARAMETER> {
    public static final int DEFAULT_INITIAL_BATTERY_CAPACITY = 32;
    private OperationFactory<RESULT, PARAMETER> operationFactory = null;
    private boolean usingReentrantLock = true;

    public OperationBattery(OperationFactory<RESULT, PARAMETER> operationFactory, boolean usingReentrantLock, int initialBatteryCapacity) {
        this.operationFactory = operationFactory;
        this.usingReentrantLock = usingReentrantLock;
        this.initializeOperationBattery(initialBatteryCapacity);
    }

    public OperationBattery(OperationFactory<RESULT, PARAMETER> operationFactory, boolean usingReentrantLock) {
        this(operationFactory, usingReentrantLock, 32);
    }

    protected abstract void initializeOperationBattery(int var1);

    protected Operation<RESULT, PARAMETER> resolveNewOperationInstanceFromOperationFactory() {
        Operation<RESULT, PARAMETER> retval = null;
        Assert.isNotNull(this.operationFactory, "OperationFactory reference is null, but is needed to create a new Operation instance.");
        retval = this.operationFactory.newOperation();
        Assert.isNotNull(retval, "OperationFactory created a null reference, but it should provide new instances.");
        if (this.usingReentrantLock) {
            boolean fair = true;
            ReentrantLock reentrantLock = new ReentrantLock(fair);
            retval = new OperationDecoratorReentrantLock<RESULT, PARAMETER>(retval, reentrantLock);
        }
        return retval;
    }

    public void setOperationFactory(OperationFactory<RESULT, PARAMETER> operationFactory) {
        this.operationFactory = operationFactory;
    }

    public boolean isUsingReentrantLock() {
        return this.usingReentrantLock;
    }

    public void setUsingReentrantLock(boolean usingReentrantLock) {
        this.usingReentrantLock = usingReentrantLock;
    }
}

