/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.battery;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.operation.OperationFactory;
import org.omnaest.utils.operation.battery.OperationBattery;
import org.omnaest.utils.structure.iterator.QueueToCircularIteratorAdapter;

public class OperationBatteryRoundRobin<RESULT, PARAMETER>
extends OperationBattery<RESULT, PARAMETER> {
    protected Queue<Operation<RESULT, PARAMETER>> operationQueue;
    private Iterator<Operation<RESULT, PARAMETER>> operationQueueIterator;

    public OperationBatteryRoundRobin(OperationFactory<RESULT, PARAMETER> operationFactory, boolean usingReentrantLock) {
        super(operationFactory, usingReentrantLock);
    }

    public OperationBatteryRoundRobin(OperationFactory<RESULT, PARAMETER> operationFactory, boolean usingReentrantLock, int initialBatteryCapacity) {
        super(operationFactory, usingReentrantLock, initialBatteryCapacity);
    }

    protected Iterator<Operation<RESULT, PARAMETER>> resolveActiveOperationQueueIterator() {
        return this.operationQueueIterator;
    }

    @Override
    public RESULT execute(PARAMETER parameter) {
        RESULT retval = null;
        Iterator<Operation<RESULT, PARAMETER>> operationQueueIterator = this.resolveActiveOperationQueueIterator();
        if (operationQueueIterator.hasNext()) {
            Operation<RESULT, PARAMETER> operation = operationQueueIterator.next();
            retval = operation.execute(parameter);
        }
        return retval;
    }

    @Override
    protected void initializeOperationBattery(int initialBatteryCapacity) {
        this.operationQueue = new ConcurrentLinkedQueue<Operation<RESULT, PARAMETER>>();
        this.operationQueueIterator = new QueueToCircularIteratorAdapter<Operation<RESULT, PARAMETER>>(this.operationQueue);
        for (int ii = 0; ii < initialBatteryCapacity; ++ii) {
            Operation operation = this.resolveNewOperationInstanceFromOperationFactory();
            this.operationQueue.offer(operation);
        }
    }
}

