/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.decorator;

import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.operation.decorator.OperationDecorator;

public class OperationDecoratorReentrantLock<RESULT, PARAMETER>
extends OperationDecorator<RESULT, PARAMETER> {
    protected ReentrantLock reentrantLock = null;

    public OperationDecoratorReentrantLock(Operation<RESULT, PARAMETER> operation, ReentrantLock reentrantLock) {
        super(operation);
        this.reentrantLock = reentrantLock;
    }

    public OperationDecoratorReentrantLock(Operation<RESULT, PARAMETER> operation) {
        super(operation);
        this.reentrantLock = new ReentrantLock();
    }

    @Override
    public RESULT execute(PARAMETER parameter) {
        RESULT retval = null;
        Assert.isNotNull((Object)this.operation, "OperationDecoratorReentrantLock cannot decorate an non existing operation. Provide an instance reference which is not null.");
        if (this.reentrantLock != null) {
            this.reentrantLock.lock();
            retval = this.operation.execute(parameter);
            this.reentrantLock.unlock();
        } else {
            retval = this.operation.execute(parameter);
        }
        return retval;
    }
}

