/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.foreach;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections.ListUtils;
import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.list.decorator.ListDecorator;
import org.omnaest.utils.threads.FutureTaskManager;

public class ForEach<E, V>
implements Operation<Result<V>, Operation<V, E>> {
    private final Iterable<E>[] iterables;
    private ExecutorService executorServiceForParallelExecution = null;
    private ExecutorService executorServiceForParallelIteration = null;
    private int numberOfThreadsForParallelIteration = 1;

    public ForEach(Iterable<E> ... iterables) {
        this.iterables = iterables;
    }

    public ForEach(Iterable<E> iterable) {
        this(new Iterable[]{iterable});
    }

    public <O> V execute(CollectionUtils.CollectionConverter<O, V> collectionConverter, Operation<O, E> ... operations) {
        return new ForEach<E, O>(this.iterables).execute(operations).convert(collectionConverter);
    }

    @Override
    public Result<V> execute(Operation<V, E> operation) {
        return this.execute(new Operation[]{operation});
    }

    @Override
    public Result<V> execute(Operation<V, E> ... operations) {
        Result<V> retval = null;
        retval = this.executorServiceForParallelExecution != null || this.executorServiceForParallelIteration != null ? this.executeMultiThreaded(operations) : this.executeSingleThreaded(operations);
        return retval;
    }

    private Result<V> executeSingleThreaded(Operation<V, E> ... operations) {
        ArrayList<V> retlist = new ArrayList<V>();
        for (Iterable<E> iterable : this.iterables) {
            if (iterable == null) continue;
            for (E element : iterable) {
                for (Operation<V, E> operation : operations) {
                    if (operation == null) continue;
                    retlist.add(operation.execute(element));
                }
            }
        }
        return new Result(ListUtils.unmodifiableList(retlist));
    }

    private Result<V> executeMultiThreaded(final Operation<V, E> ... operations) {
        final CopyOnWriteArrayList retlist = new CopyOnWriteArrayList();
        final FutureTaskManager futureTaskManagerExecution = new FutureTaskManager(this.executorServiceForParallelExecution);
        FutureTaskManager futureTaskManagerIteration = new FutureTaskManager(this.executorServiceForParallelIteration);
        for (Iterable<E> iterable : this.iterables) {
            if (iterable == null) continue;
            final Iterator<E> iterator = iterable.iterator();
            Runnable runnableForIteration = new Runnable(){

                @Override
                public void run() {
                    try {
                        block2: while (true) {
                            final Object element = iterator.next();
                            Operation[] arr$ = operations;
                            int len$ = arr$.length;
                            int i$ = 0;
                            while (true) {
                                if (i$ >= len$) continue block2;
                                final Operation operation = arr$[i$];
                                if (operation != null) {
                                    if (futureTaskManagerExecution.hasExecutorService()) {
                                        futureTaskManagerExecution.submitAndManage(new Callable<V>(){

                                            @Override
                                            public V call() throws Exception {
                                                return operation.execute(element);
                                            }
                                        });
                                    } else {
                                        retlist.add(operation.execute(element));
                                    }
                                }
                                ++i$;
                            }
                            break;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (futureTaskManagerExecution.hasExecutorService()) {
                            retlist.addAll(futureTaskManagerExecution.waitForAllTasksToFinish().getResult());
                        }
                        return;
                    }
                }
            };
            if (futureTaskManagerIteration.hasExecutorService()) {
                for (int ii = 1; ii <= this.numberOfThreadsForParallelIteration; ++ii) {
                    futureTaskManagerIteration.submitAndManage(runnableForIteration);
                }
                futureTaskManagerIteration.waitForAllTasksToFinish();
                continue;
            }
            runnableForIteration.run();
        }
        return new Result(ListUtils.unmodifiableList(retlist));
    }

    public ForEach<E, V> doExecuteInParallelUsing(ExecutorService executorService) {
        this.executorServiceForParallelExecution = executorService;
        return this;
    }

    public ForEach<E, V> doIterateInParallelUsing(ExecutorService executorService, int numberOfThreads) {
        this.executorServiceForParallelIteration = executorService;
        this.numberOfThreadsForParallelIteration = numberOfThreads;
        return this;
    }

    public static class Result<V>
    extends ListDecorator<V> {
        private static final long serialVersionUID = -3838376068713161966L;

        protected Result(List<V> list) {
            super(list);
        }

        public <TO> TO convert(CollectionUtils.CollectionConverter<V, TO> collectionConverter) {
            return CollectionUtils.convert(this.list, collectionConverter);
        }

        public boolean areAllValuesEqualTo(V value) {
            return this.areNumberOfValuesEqualTo(value, this.size());
        }

        public boolean isAnyValueEqualTo(V value) {
            return this.areNumberOfValuesEqualTo(value, 1);
        }

        public boolean areNumberOfValuesEqualTo(V value, int number) {
            boolean retval = false;
            int counter = 0;
            if (value != null) {
                for (Object iValue : this) {
                    if ((counter += value.equals(iValue) ? 1 : 0) < number) continue;
                    retval = true;
                    break;
                }
            }
            return retval;
        }
    }
}

