/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.foreach;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.strings.StringReplacer;
import org.omnaest.utils.structure.element.ElementStream;
import org.omnaest.utils.structure.iterator.ElementStreamToIteratorAdapter;

public class Range
implements Iterable<Long> {
    private static final long DEFAULT_STEP = 1L;
    private Long numberFrom = null;
    private Long numberTo = null;
    private Long step = 1L;

    public Range(Long numberFrom, Long numberTo, Long step) {
        this.numberFrom = numberFrom;
        this.numberTo = numberTo;
        this.step = step;
    }

    public Range(long numberFrom, long numberTo) {
        this.numberFrom = numberFrom;
        this.numberTo = numberTo;
        this.step = Range.determineDefaultStep(this.numberFrom, this.numberTo);
    }

    private static long determineDefaultStep(Long numberFrom, Long numberTo) {
        return numberTo >= numberFrom ? 1L : -1L;
    }

    public Range(Long numberFrom, Long numberTo) {
        this.numberFrom = numberFrom;
        this.numberTo = numberTo;
        this.step = Range.determineDefaultStep(this.numberFrom, this.numberTo);
    }

    public Range(int numberFrom, int numberTo) {
        this.numberFrom = numberFrom;
        this.numberTo = numberTo;
        this.step = Range.determineDefaultStep(this.numberFrom, this.numberTo);
    }

    public Range(String rangeExpression) {
        String[] tokens;
        String[] matchingTokens;
        Assert.isNotNull(rangeExpression);
        StringReplacer.ReplacementResult replacementResult = new StringReplacer("\\:([0-9]*)$").setGroup(1).findAndRemoveFirst(rangeExpression);
        boolean hasDeclaredStep = replacementResult.hasMatchingTokens();
        if (hasDeclaredStep && (matchingTokens = replacementResult.getMatchingTokens()) != null && matchingTokens.length == 1) {
            String stepString = matchingTokens[0];
            Assert.isTrue(StringUtils.isNumeric((CharSequence)stepString), "Step must be numerical but was " + stepString);
            this.step = NumberUtils.toLong((String)stepString, (long)1L);
        }
        Assert.isTrue((tokens = (rangeExpression = replacementResult.getOutput()).split("-")).length == 2 || tokens.length == 1);
        if (tokens.length == 2) {
            Assert.isTrue(StringUtils.isNumeric((CharSequence)tokens[0]), "Range start must be numerical but was " + tokens[0]);
            Assert.isTrue(StringUtils.isNumeric((CharSequence)tokens[1]), "Range start must be numerical but was " + tokens[1]);
            this.numberFrom = Long.valueOf(tokens[0]);
            this.numberTo = Long.valueOf(tokens[1]);
        } else if (tokens.length == 1) {
            Assert.isTrue(StringUtils.isNumeric((CharSequence)tokens[0]), "Range start and end must be numerical but was " + tokens[0]);
            this.numberFrom = this.numberTo = Long.valueOf(tokens[0]);
        }
        if (!hasDeclaredStep) {
            this.step = Range.determineDefaultStep(this.numberFrom, this.numberTo);
        }
        Assert.isTrue(this.numberTo == this.numberFrom || Math.signum(this.numberTo - this.numberFrom) == Math.signum(this.step.longValue()), "The given end number cannot be reached by the given start number and step " + this);
    }

    public boolean isWithinRange(long number) {
        return number >= this.numberFrom && number <= this.numberTo;
    }

    @Override
    public Iterator<Long> iterator() {
        return new ElementStreamToIteratorAdapter<Long>(new ElementStream<Long>(){
            private Long currentValue;
            {
                this.currentValue = Range.this.numberFrom;
            }

            @Override
            public Long next() {
                Long retval = this.currentValue;
                1 var2_2 = this;
                var2_2.currentValue = var2_2.currentValue + Range.this.step;
                return retval <= Range.this.numberTo ? retval : null;
            }
        });
    }

    public Long getNumberFrom() {
        return this.numberFrom;
    }

    public Long getNumberTo() {
        return this.numberTo;
    }

    public Long getStep() {
        return this.step;
    }

    public int[] toIntArray() {
        int[] retvals = null;
        int numberFrom = 0;
        int numberTo = 0;
        if (this.numberFrom != null) {
            numberFrom = this.numberFrom.intValue();
        }
        if (this.numberTo != null) {
            numberTo = this.numberTo.intValue();
        }
        int step = this.step.intValue();
        int delta = (numberTo - numberFrom) / step;
        retvals = new int[delta + 1];
        for (int ii = 0; ii <= delta; ++ii) {
            retvals[ii] = numberFrom + ii * step;
        }
        return retvals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Range [numberFrom=");
        builder.append(this.numberFrom);
        builder.append(", numberTo=");
        builder.append(this.numberTo);
        builder.append(", step=");
        builder.append(this.step);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.numberFrom == null ? 0 : this.numberFrom.hashCode());
        result = 31 * result + (this.numberTo == null ? 0 : this.numberTo.hashCode());
        result = 31 * result + (this.step == null ? 0 : this.step.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.numberFrom == null ? other.numberFrom != null : !this.numberFrom.equals(other.numberFrom)) {
            return false;
        }
        if (this.numberTo == null ? other.numberTo != null : !this.numberTo.equals(other.numberTo)) {
            return false;
        }
        return !(this.step == null ? other.step != null : !this.step.equals(other.step));
    }
}

