/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.operation.special;

import org.omnaest.utils.operation.Operation;
import org.omnaest.utils.time.DurationCapture;

public class OperationBlockingToFastRepeatingExecutions<RESULT, PARAMETER>
implements Operation<RESULT, PARAMETER> {
    protected Operation<RESULT, PARAMETER> operation = null;
    protected int maximumNumberOfToleratedTooFastInvocations = 0;
    protected long minimalDurationBetweenExecutionInMilliseconds = 1L;
    protected long forcedDurationAfterToFastInvocationInMilliseconds = 100L;
    protected boolean lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls = false;
    protected DurationCapture durationCapture = DurationCapture.newInstance();
    protected long alreadyToleratedToFastInvocations = 0L;

    public OperationBlockingToFastRepeatingExecutions(Operation<RESULT, PARAMETER> operation, long minimalDurationBetweenExecutionInMilliseconds, long forcedDurationAfterToFastInvocationInMilliseconds) {
        this.operation = operation;
        this.minimalDurationBetweenExecutionInMilliseconds = minimalDurationBetweenExecutionInMilliseconds;
        this.forcedDurationAfterToFastInvocationInMilliseconds = forcedDurationAfterToFastInvocationInMilliseconds;
    }

    public OperationBlockingToFastRepeatingExecutions(Operation<RESULT, PARAMETER> operation, int maximumNumberOfToleratedTooFastInvocations, long minimalDurationBetweenExecutionInMilliseconds, long forcedDurationAfterToFastInvocationInMilliseconds) {
        this.operation = operation;
        this.maximumNumberOfToleratedTooFastInvocations = maximumNumberOfToleratedTooFastInvocations;
        this.minimalDurationBetweenExecutionInMilliseconds = minimalDurationBetweenExecutionInMilliseconds;
        this.forcedDurationAfterToFastInvocationInMilliseconds = forcedDurationAfterToFastInvocationInMilliseconds;
    }

    @Override
    public RESULT execute(PARAMETER parameter) {
        this.throwToFastInvocationExceptionIfInvocationIsTooFast();
        return this.operation != null ? (RESULT)this.operation.execute(parameter) : null;
    }

    private void throwToFastInvocationExceptionIfInvocationIsTooFast() throws ToFastInvocationException {
        long interimTimeInMilliseconds = this.durationCapture.getInterimTimeInMilliseconds();
        if (!this.lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls && interimTimeInMilliseconds <= this.minimalDurationBetweenExecutionInMilliseconds) {
            if (this.alreadyToleratedToFastInvocations++ >= (long)this.maximumNumberOfToleratedTooFastInvocations) {
                this.lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls = true;
                long durationToWaitInMilliseconds = this.minimalDurationBetweenExecutionInMilliseconds - interimTimeInMilliseconds;
                throw new ToFastInvocationException(durationToWaitInMilliseconds);
            }
        } else {
            if (this.lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls && interimTimeInMilliseconds <= this.forcedDurationAfterToFastInvocationInMilliseconds) {
                long durationToWaitInMilliseconds = this.forcedDurationAfterToFastInvocationInMilliseconds - interimTimeInMilliseconds;
                throw new ToFastInvocationException(durationToWaitInMilliseconds);
            }
            this.lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls = false;
            this.alreadyToleratedToFastInvocations = 0L;
            this.durationCapture.startTimeMeasurement();
        }
    }

    public boolean hasLastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls() {
        return this.lastInvocationExceededMinimalDurationBetweenTwoExcecutionCalls;
    }

    public static class ToFastInvocationException
    extends RuntimeException {
        private static final long serialVersionUID = 610230248396653113L;
        private long durationToWaitInMilliseconds = 0L;

        public ToFastInvocationException(long durationToWaitInMilliseconds) {
            super("The Operation#execute(...) method was invoked to often within a given period of time. Please wait for " + durationToWaitInMilliseconds + " ms");
            this.durationToWaitInMilliseconds = durationToWaitInMilliseconds;
        }

        public long getDurationToWaitInMilliseconds() {
            return this.durationToWaitInMilliseconds;
        }
    }
}

