/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile;

import java.io.File;
import org.omnaest.utils.propertyfile.content.PropertyFileContent;
import org.omnaest.utils.propertyfile.content.parser.PropertyFileContentParser;
import org.omnaest.utils.propertyfile.content.parser.PropertyFileContentWriter;

public class PropertyFile {
    public static final String FILE_ENCODING_DEFAULT = "UTF-8";
    protected File file = null;
    protected String fileEncoding = "UTF-8";
    protected boolean useJavaStyleUnicodeEscaping = false;
    protected PropertyFileContent propertyFileContent = new PropertyFileContent();

    public PropertyFile(String propertyFileName) {
        this(new File(propertyFileName));
    }

    public PropertyFile(File propertyFile) {
        this.file = propertyFile;
    }

    public void load() {
        this.propertyFileContent = PropertyFileContentParser.parsePropertyFileContent(this.file, this.fileEncoding, this.useJavaStyleUnicodeEscaping);
    }

    public void load(String fileContent) {
        this.propertyFileContent = PropertyFileContentParser.parsePropertyFileContent(fileContent, this.useJavaStyleUnicodeEscaping);
    }

    public String toString() {
        return PropertyFileContentWriter.writePropertyFileContentToString(this.propertyFileContent, this.useJavaStyleUnicodeEscaping);
    }

    public void store() {
        PropertyFileContentWriter.writePropertyFileContentToFile(this.propertyFileContent, this.file, this.fileEncoding, this.useJavaStyleUnicodeEscaping);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public PropertyFileContent getPropertyFileContent() {
        return this.propertyFileContent;
    }

    public void setPropertyFileContent(PropertyFileContent propertyFileContent) {
        this.propertyFileContent = propertyFileContent;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public PropertyFile setUseJavaStyleUnicodeEscaping(boolean useJavaStyleUnicodeEscaping) {
        this.useJavaStyleUnicodeEscaping = useJavaStyleUnicodeEscaping;
        return this;
    }
}

