/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.omnaest.utils.propertyfile.content.Element;
import org.omnaest.utils.propertyfile.content.PropertyMap;
import org.omnaest.utils.propertyfile.content.element.Property;
import org.omnaest.utils.propertyfile.content.index.Index;
import org.omnaest.utils.propertyfile.content.index.IndexManager;
import org.omnaest.utils.propertyfile.content.parser.PropertyFileContentWriter;

public class PropertyFileContent {
    protected List<Element> elementList = new ArrayList<Element>();
    protected IndexManager indexManager = new IndexManager();
    protected String lineSeparator = null;

    public List<Element> getElementList() {
        return new ArrayList<Element>(this.elementList);
    }

    public List<Element> getElementListAscendingByIndexPosition() {
        List<Element> retlist = this.getElementList();
        Comparator<Element> comparator = new Comparator<Element>(){

            @Override
            public int compare(Element element1, Element element2) {
                Integer index1 = element1.resolveIndexPosition();
                Integer index2 = element2.resolveIndexPosition();
                return index1.compareTo(index2);
            }
        };
        Collections.sort(retlist, comparator);
        return retlist;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> retlist = new ArrayList<Property>();
        for (Element element : this.elementList) {
            if (!(element instanceof Property)) continue;
            retlist.add((Property)element);
        }
        return retlist;
    }

    public void appendElement(Element element) {
        if (element != null) {
            this.elementList.add(element);
            Index line = this.indexManager.createNewAppendedIndex();
            element.setIndex(line);
        }
    }

    public void insertElementAfter(Element element, Element elementBefore) {
        if (element != null && elementBefore != null) {
            this.elementList.add(element);
            Index currentIndex = elementBefore.getIndex();
            Index index = this.indexManager.getPreviousIndex(currentIndex);
            element.setIndex(index);
        }
    }

    public int size() {
        return this.elementList.size();
    }

    public Element getElementByIndexPosition(int index) {
        Element retval = null;
        for (Element element : this.elementList) {
            if (element.resolveIndexPosition() != index) continue;
            retval = element;
            break;
        }
        return retval;
    }

    public void removeElement(Element element) {
        if (element != null && this.elementList.contains(element)) {
            this.elementList.remove(element);
            Index index = element.getIndex();
            this.indexManager.removeIndex(index);
        }
    }

    public void clear() {
        this.elementList.clear();
        this.indexManager.clear();
    }

    public void replaceElement(Element elementOld, Element elementNew) {
        if (elementNew != null && elementOld != null) {
            Index index = elementOld.getIndex();
            elementNew.setIndex(index);
            this.elementList.remove(elementOld);
            this.elementList.add(elementNew);
        }
    }

    public PropertyMap getPropertyMap() {
        return new PropertyMap(this);
    }

    public boolean hasPropertyKey(String propertyKey) {
        boolean retval = false;
        if (propertyKey != null) {
            PropertyMap propertyMap = this.getPropertyMap();
            retval = propertyMap.containsKey(propertyKey);
        }
        return retval;
    }

    public boolean hasPropertyKeyAndValueList(String propertyKey, List<String> propertyValueList) {
        boolean retval = false;
        if (propertyKey != null && propertyValueList != null) {
            PropertyMap propertyMap = this.getPropertyMap();
            Property property = propertyMap.get(propertyKey);
            retval = property != null && ((Object)propertyValueList).equals(property.getValueList());
        }
        return retval;
    }

    public boolean hasProperty(Property property) {
        boolean retval = false;
        if (property != null) {
            Property propertyFound = this.getPropertyMap().get(property.getKey());
            retval = property.equals(propertyFound);
        }
        return retval;
    }

    public boolean hasPropertyWithSameKeyAndValue(Property property) {
        boolean retval = false;
        if (property != null) {
            Property propertyFound = this.getPropertyMap().get(property.getKey());
            retval = property.equalsInKeyAndValue(propertyFound);
        }
        return retval;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String toString() {
        return PropertyFileContentWriter.writePropertyFileContentToString(this);
    }
}

