/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile.content;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omnaest.utils.propertyfile.content.MapAbstract;
import org.omnaest.utils.propertyfile.content.PropertyFileContent;
import org.omnaest.utils.propertyfile.content.element.Property;

public class PropertyMap
extends MapAbstract<String, Property> {
    protected PropertyFileContent propertyFileContent = null;

    protected PropertyMap(PropertyFileContent propertyFileContent) {
        this.propertyFileContent = propertyFileContent;
    }

    @Override
    public int size() {
        return this.propertyFileContent.getPropertyList().size();
    }

    @Override
    public Property get(Object key) {
        Property retval = null;
        if (key instanceof String) {
            List<Property> propertyList = this.propertyFileContent.getPropertyList();
            for (Property property : propertyList) {
                if (!key.equals(property.getKey())) continue;
                retval = property;
                break;
            }
        }
        return retval;
    }

    public Property put(Property property) {
        Property retval = null;
        if (property != null) {
            retval = this.put(property.getKey(), property);
        }
        return retval;
    }

    @Override
    public Property put(String key, Property property) {
        Property retval = this.get(key);
        if (property != null) {
            if (retval != null) {
                Property elementOld = retval;
                Property elementNew = property;
                this.propertyFileContent.replaceElement(elementOld, elementNew);
            } else {
                this.propertyFileContent.appendElement(property);
            }
        }
        return retval;
    }

    @Override
    public Property remove(Object key) {
        Property property = this.get(key);
        if (property != null) {
            this.propertyFileContent.removeElement(property);
        }
        return property;
    }

    @Override
    public void clear() {
        List<Property> propertyList = this.propertyFileContent.getPropertyList();
        for (Property property : propertyList) {
            this.propertyFileContent.removeElement(property);
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> retset = new HashSet<String>();
        List<Property> propertyList = this.propertyFileContent.getPropertyList();
        for (Property property : propertyList) {
            retset.add(property.getKey());
        }
        return retset;
    }

    @Override
    public Collection<Property> values() {
        return this.propertyFileContent.getPropertyList();
    }
}

