/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile.content.index;

import java.util.ArrayList;
import java.util.List;
import org.omnaest.utils.propertyfile.content.index.Index;

public class IndexManager {
    protected List<Index> indexList = new ArrayList<Index>();

    public List<Index> getIndexList() {
        return this.indexList;
    }

    public Index getPreviousIndex(Index currentIndex) {
        int indexPosition;
        Index index = null;
        if (currentIndex != null && (indexPosition = this.indexList.indexOf(currentIndex)) > 0) {
            index = this.indexList.get(indexPosition - 1);
        }
        return index;
    }

    public void removeIndex(Index index) {
        if (index != null && this.indexList.contains(index)) {
            this.indexList.remove(index);
        }
    }

    public void insertIndex(int indexPosition, Index index) {
        if (index != null) {
            this.indexList.add(indexPosition, index);
        }
    }

    public int resolveIndexPosition(Index index) {
        int retval = -1;
        if (index != null) {
            retval = this.indexList.indexOf(index);
        }
        return retval;
    }

    public Index getNextIndex(Index currentIndex) {
        int indexOf;
        Index index = null;
        if (currentIndex != null && (indexOf = this.indexList.indexOf(currentIndex)) < this.indexList.size() - 1) {
            index = this.indexList.get(indexOf + 1);
        }
        return index;
    }

    public Index createNewAppendedIndex() {
        Index index = new Index(this);
        this.indexList.add(index);
        return index;
    }

    public Index createNewPreviousIndex(Index currentIndex) {
        Index index = null;
        if (currentIndex != null) {
            index = new Index(this);
            int indexPosition = this.indexList.indexOf(currentIndex);
            this.indexList.add(indexPosition, index);
        }
        return index;
    }

    public void clear() {
        this.indexList.clear();
    }
}

