/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile.content.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.propertyfile.content.PropertyFileContent;
import org.omnaest.utils.propertyfile.content.element.BlankLineElement;
import org.omnaest.utils.propertyfile.content.element.Comment;
import org.omnaest.utils.propertyfile.content.element.Property;

public class PropertyFileContentParser {
    private static final String DEFAULT_LINESEPARATOR = System.getProperty("line.separator");

    public static PropertyFileContent parsePropertyFileContent(File file, String fileEncoding) {
        boolean useJavaStyleUnicodeEscaping = false;
        return PropertyFileContentParser.parsePropertyFileContent(file, fileEncoding, useJavaStyleUnicodeEscaping);
    }

    public static PropertyFileContent parsePropertyFileContent(File file, String fileEncoding, boolean useJavaStyleUnicodeEscaping) {
        PropertyFileContent propertyFileContent = null;
        if (file != null && file.exists()) {
            try {
                String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (String)fileEncoding);
                propertyFileContent = PropertyFileContentParser.parsePropertyFileContent(fileContent, useJavaStyleUnicodeEscaping);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            propertyFileContent = new PropertyFileContent();
        }
        return propertyFileContent;
    }

    public static PropertyFileContent parsePropertyFileContent(String fileContent) {
        boolean useJavaStyleUnicodeEscaping = false;
        return PropertyFileContentParser.parsePropertyFileContent(fileContent, useJavaStyleUnicodeEscaping);
    }

    public static PropertyFileContent parsePropertyFileContent(String fileContent, boolean useJavaStyleUnicodeEscaping) {
        PropertyFileContent propertyFileContent = new PropertyFileContent();
        if (fileContent != null) {
            try {
                ArrayList<String> lineContentList = new ArrayList<String>();
                Scanner scanner = new Scanner(fileContent);
                while (scanner.hasNextLine()) {
                    lineContentList.add(scanner.nextLine());
                }
                if (fileContent.endsWith("\n") || fileContent.endsWith("\r")) {
                    lineContentList.add("");
                }
                String lineSeparator = DEFAULT_LINESEPARATOR;
                if (fileContent.contains("\r\n")) {
                    lineSeparator = "\r\n";
                } else if (fileContent.contains("\n")) {
                    lineSeparator = "\n";
                } else if (fileContent.contains("\r")) {
                    lineSeparator = "\r";
                }
                propertyFileContent.setLineSeparator(lineSeparator);
                Pattern patternComment = Pattern.compile("([^\\:\\=]{0,4}[\\s]*)(\\!|\\#)(.*)");
                Pattern patternProperty = Pattern.compile("([^\\w]*)([^\\s\\:\\=]+)(\\s*=\\s*|\\s*\\:\\s*|\\s+)(.*[^\\\\]|[^\\\\]?)(\\\\?)");
                Pattern patternBlankLine = Pattern.compile("([^\\w]*)");
                Pattern patternPropertyOngoingLine = Pattern.compile("(.*[^\\\\]|[^\\\\]?)(\\\\?)");
                Property propertyMultiline = null;
                for (String lineContent : lineContentList) {
                    if (propertyMultiline == null) {
                        Matcher matcherComment = patternComment.matcher(lineContent);
                        Matcher matcherProperty = patternProperty.matcher(lineContent);
                        Matcher matcherBlankLine = patternBlankLine.matcher(lineContent);
                        if (matcherComment.matches()) {
                            Comment comment = new Comment();
                            comment.setPrefixBlanks(matcherComment.group(1));
                            comment.setCommentIndicator(matcherComment.group(2));
                            comment.setComment(matcherComment.group(3));
                            propertyFileContent.appendElement(comment);
                            continue;
                        }
                        if (matcherProperty.matches()) {
                            Property property = new Property();
                            property.setPrefixBlanks(matcherProperty.group(1));
                            property.setKey(matcherProperty.group(2));
                            property.setDelimiter(matcherProperty.group(3));
                            List<String> valueList = property.getValueList();
                            String value = PropertyFileContentParser.unescapeJavaStyleIfNecessary(useJavaStyleUnicodeEscaping, matcherProperty.group(4));
                            valueList.add(value);
                            if (StringUtils.isNotBlank((CharSequence)matcherProperty.group(5))) {
                                propertyMultiline = property;
                                continue;
                            }
                            propertyFileContent.appendElement(property);
                            continue;
                        }
                        if (!matcherBlankLine.matches()) continue;
                        propertyFileContent.appendElement(new BlankLineElement().setBlanks(matcherBlankLine.group(1)));
                        continue;
                    }
                    Matcher matcherPropertyOngoingLine = patternPropertyOngoingLine.matcher(lineContent);
                    if (!matcherPropertyOngoingLine.matches()) continue;
                    List<String> valueList = propertyMultiline.getValueList();
                    String value = PropertyFileContentParser.unescapeJavaStyleIfNecessary(useJavaStyleUnicodeEscaping, matcherPropertyOngoingLine.group(1));
                    valueList.add(value);
                    if (!StringUtils.isBlank((CharSequence)matcherPropertyOngoingLine.group(2))) continue;
                    propertyFileContent.appendElement(propertyMultiline);
                    propertyMultiline = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return propertyFileContent;
    }

    private static String unescapeJavaStyleIfNecessary(boolean useJavaStyleUnicodeEscaping, String group) {
        return useJavaStyleUnicodeEscaping ? StringEscapeUtils.unescapeJava((String)group) : group;
    }
}

