/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.propertyfile.content.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.propertyfile.content.Element;
import org.omnaest.utils.propertyfile.content.PropertyFileContent;
import org.omnaest.utils.propertyfile.content.element.BlankLineElement;
import org.omnaest.utils.propertyfile.content.element.Comment;
import org.omnaest.utils.propertyfile.content.element.Property;
import org.omnaest.utils.structure.container.ByteArrayContainer;

public class PropertyFileContentWriter {
    protected static final String LINE_SEPARATOR_OS_DEFAULT = System.getProperty("line.separator");

    public static void writePropertyFileContentToFile(PropertyFileContent propertyFileContent, File file, String fileEncoding) {
        boolean useJavaStyleUnicodeEscaping = false;
        PropertyFileContentWriter.writePropertyFileContentToFile(propertyFileContent, file, fileEncoding, useJavaStyleUnicodeEscaping);
    }

    public static void writePropertyFileContentToFile(PropertyFileContent propertyFileContent, File file, String fileEncoding, boolean useJavaStyleUnicodeEscaping) {
        if (propertyFileContent != null && file != null && fileEncoding != null) {
            try {
                FileUtils.writeStringToFile((File)file, (String)"", (String)fileEncoding);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), fileEncoding);
                PropertyFileContentWriter.writePropertyFileContentToOutputStreamWriter(propertyFileContent, outputStreamWriter, useJavaStyleUnicodeEscaping);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String writePropertyFileContentToString(PropertyFileContent propertyFileContent) {
        boolean useJavaStyleUnicodeEscaping = false;
        return PropertyFileContentWriter.writePropertyFileContentToString(propertyFileContent, useJavaStyleUnicodeEscaping);
    }

    public static String writePropertyFileContentToString(PropertyFileContent propertyFileContent, boolean useJavaStyleUnicodeEscaping) {
        String retval = null;
        if (propertyFileContent != null) {
            ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
            OutputStreamWriter outputStreamWriter = byteArrayContainer.getOutputStreamWriter();
            PropertyFileContentWriter.writePropertyFileContentToOutputStreamWriter(propertyFileContent, outputStreamWriter, useJavaStyleUnicodeEscaping);
            retval = byteArrayContainer.toString();
        }
        return retval;
    }

    public static void writePropertyFileContentToOutputStreamWriter(PropertyFileContent propertyFileContent, OutputStreamWriter outputStreamWriter) {
        boolean useJavaStyleUnicodeEscaping = false;
        PropertyFileContentWriter.writePropertyFileContentToOutputStreamWriter(propertyFileContent, outputStreamWriter, useJavaStyleUnicodeEscaping);
    }

    public static void writePropertyFileContentToOutputStreamWriter(PropertyFileContent propertyFileContent, OutputStreamWriter outputStreamWriter, boolean useJavaStyleUnicodeEscaping) {
        if (propertyFileContent != null && outputStreamWriter != null) {
            try {
                ArrayList<String> contentList = new ArrayList<String>();
                List<Element> elementList = propertyFileContent.getElementListAscendingByIndexPosition();
                for (Element element : elementList) {
                    String prefixBlanks;
                    if (element instanceof Comment) {
                        Comment comment = (Comment)element;
                        prefixBlanks = comment.getPrefixBlanks();
                        String commentIndicator = comment.getCommentIndicator();
                        String commentString = comment.getComment();
                        String text = prefixBlanks + commentIndicator + commentString;
                        contentList.add(text);
                        continue;
                    }
                    if (element instanceof Property) {
                        Property property = (Property)element;
                        prefixBlanks = property.getPrefixBlanks();
                        String key = property.getKey();
                        String delimiter = property.getDelimiter();
                        List<String> valueList = property.getValueList();
                        String value = PropertyFileContentWriter.escapeJavaStyleIfNecessary(useJavaStyleUnicodeEscaping, valueList.get(0));
                        String text = prefixBlanks + key + delimiter + value;
                        if (valueList.size() > 1) {
                            text = text + "\\";
                        }
                        contentList.add(text);
                        for (int ii = 1; ii < valueList.size(); ++ii) {
                            value = PropertyFileContentWriter.escapeJavaStyleIfNecessary(useJavaStyleUnicodeEscaping, valueList.get(ii));
                            if (ii < valueList.size() - 1) {
                                value = value + "\\";
                            }
                            contentList.add(value);
                        }
                        continue;
                    }
                    if (!(element instanceof BlankLineElement)) continue;
                    BlankLineElement blankLineElement = (BlankLineElement)element;
                    contentList.add(blankLineElement.getBlanks());
                }
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                String lineSeparator = StringUtils.defaultString((String)propertyFileContent.getLineSeparator(), (String)LINE_SEPARATOR_OS_DEFAULT);
                boolean firstLine = true;
                for (String content : contentList) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        bufferedWriter.write(lineSeparator);
                    }
                    bufferedWriter.write(content);
                }
                bufferedWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String escapeJavaStyleIfNecessary(boolean useJavaStyleUnicodeEscaping, String value) {
        return useJavaStyleUnicodeEscaping ? StringEscapeUtils.escapeJava((String)value) : value;
    }
}

