/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanMethodInformation;
import org.omnaest.utils.proxy.BeanProperty;
import org.omnaest.utils.proxy.MethodName;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class MethodCallCapturer {
    public final MethodName methodName = new MethodName(this);
    public final BeanProperty beanProperty = new BeanProperty(this);
    protected final Map<Object, List<MethodCallCaptureContext>> stubToMethodCallCaptureContextListMap = Collections.synchronizedMap(new IdentityHashMap());
    protected Object lastActiveRootStub = null;

    public <E> E newInstanceOfCapturedType(Class<? extends E> clazz) {
        return this.newInstanceOfCapturedType(new CapturedTypeInstanceCreationConfiguration(clazz, null, false));
    }

    public <E> E newInstanceOfCapturedTypeWhichIsMethodCallCapturerAware(Class<? extends E> clazz) {
        CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration = new CapturedTypeInstanceCreationConfiguration(clazz, new Class[]{MethodCallCapturerAware.class}, false);
        return this.newInstanceOfCapturedType(capturedTypeInstanceCreationConfiguration);
    }

    public <E> E newInstanceOfTransitivlyCapturedType(Class<? extends E> clazz) {
        return this.newInstanceOfCapturedType(new CapturedTypeInstanceCreationConfiguration(clazz, null, true));
    }

    public <E> E newInstanceOfTransitivlyCapturedTypeWhichIsMethodCallCapturerAware(Class<? extends E> clazz) {
        CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration = new CapturedTypeInstanceCreationConfiguration(clazz, new Class[]{MethodCallCapturerAware.class}, true);
        return this.newInstanceOfCapturedType(capturedTypeInstanceCreationConfiguration);
    }

    protected <E> E newInstanceOfCapturedType(CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration) {
        MethodCaptureMethodInvocationHandler methodCaptureMethodInvocationHandler = new MethodCaptureMethodInvocationHandler(capturedTypeInstanceCreationConfiguration);
        Object stubInstance = StubCreator.newStubInstance(capturedTypeInstanceCreationConfiguration.getType(), (Class[])ArrayUtils.add((Object[])capturedTypeInstanceCreationConfiguration.getInterfaces(), TypeCaptureAware.class), methodCaptureMethodInvocationHandler);
        if (capturedTypeInstanceCreationConfiguration.getPreviousMethodCallCaptureContext() == null) {
            this.lastActiveRootStub = stubInstance;
        }
        return (E)stubInstance;
    }

    protected List<MethodCallCaptureContext> getOrCreateMethodCallCaptureContextListForStub(Object stub) {
        List<MethodCallCaptureContext> retlist = null;
        if (!this.stubToMethodCallCaptureContextListMap.containsKey(stub)) {
            this.stubToMethodCallCaptureContextListMap.put(stub, Collections.synchronizedList(new ArrayList()));
        }
        retlist = this.stubToMethodCallCaptureContextListMap.get(stub);
        return retlist;
    }

    public List<MethodCallCaptureContext> getMethodCallCaptureContextList() {
        return ListUtils.mergeAll(this.stubToMethodCallCaptureContextListMap.values());
    }

    public List<MethodCallCaptureContext> getMethodCallCaptureContextList(Object stub) {
        return new ArrayList<MethodCallCaptureContext>(this.getOrCreateMethodCallCaptureContextListForStub(stub));
    }

    public List<MethodCallCaptureContext> getMethodCallCaptureContextWithMergedHierarchyList() {
        return this.getMethodCallCaptureContextWithMergedHierarchyList(this.lastActiveRootStub);
    }

    public List<MethodCallCaptureContext> getMethodCallCaptureContextWithMergedHierarchyList(Object stub) {
        List<MethodCallCaptureContext> retlist = this.getMethodCallCaptureContextList(stub);
        this.mergeHierarchicalMethodCallCaptureContextList(retlist);
        return retlist;
    }

    public MethodCallCaptureContext getLastMethodCallContext() {
        List<MethodCallCaptureContext> methodCallCaptureContextList = this.getMethodCallCaptureContextList();
        int methodCallCaptureListSize = methodCallCaptureContextList.size();
        return methodCallCaptureListSize > 0 ? methodCallCaptureContextList.get(methodCallCaptureListSize - 1) : null;
    }

    public MethodCallCapturer reset() {
        this.stubToMethodCallCaptureContextListMap.clear();
        return this;
    }

    public MethodCallCapturer reset(Object stub) {
        this.getOrCreateMethodCallCaptureContextListForStub(stub).clear();
        return this;
    }

    public List<String> getCapturedCanonicalPropertyNameList() {
        return this.getCapturedCanonicalPropertyNameList(this.lastActiveRootStub);
    }

    public List<String> getCapturedCanonicalPropertyNameList(final Object stub) {
        List<String> canonicalPropertyNameList = null;
        ElementConverter<MethodCallCaptureContext, String> elementTransformer = new ElementConverter<MethodCallCaptureContext, String>(){

            @Override
            public String convert(MethodCallCaptureContext methodCallCaptureContext) {
                return methodCallCaptureContext.determineCanonicalPropertyName(stub);
            }
        };
        canonicalPropertyNameList = ListUtils.convert(this.getOrCreateMethodCallCaptureContextListForStub(stub), elementTransformer);
        return canonicalPropertyNameList;
    }

    public List<String> getCapturedCanonicalMethodNameList(final Object stub) {
        List<String> canonicalMethodNameList = null;
        ElementConverter<MethodCallCaptureContext, String> elementTransformer = new ElementConverter<MethodCallCaptureContext, String>(){

            @Override
            public String convert(MethodCallCaptureContext methodCallCaptureContext) {
                return methodCallCaptureContext.determineCanonicalMethodName(stub);
            }
        };
        canonicalMethodNameList = ListUtils.convert(this.getOrCreateMethodCallCaptureContextListForStub(stub), elementTransformer);
        return canonicalMethodNameList;
    }

    public List<String> getCapturedCanonicalMethodNameList() {
        return this.getCapturedCanonicalMethodNameList(this.lastActiveRootStub);
    }

    public List<String> getCapturedCanonicalMethodNameListWithMergedHierarchyCalls() {
        return this.getCapturedCanonicalMethodNameListWithMergedHierarchyCalls(this.lastActiveRootStub);
    }

    public List<String> getCapturedCanonicalPropertyNameListWithMergedHierarchyCalls() {
        return this.getCapturedCanonicalPropertyNameListWithMergedHierarchyCalls(this.lastActiveRootStub);
    }

    public List<String> getCapturedCanonicalPropertyNameListWithMergedHierarchyCalls(Object stub) {
        ArrayList<String> retlist = new ArrayList<String>();
        List<String> capturedCanonicalPropertyNameList = this.getCapturedCanonicalPropertyNameList(stub);
        if (capturedCanonicalPropertyNameList != null) {
            this.mergeHierarchicalNameList(capturedCanonicalPropertyNameList);
            retlist.addAll(capturedCanonicalPropertyNameList);
        }
        return retlist;
    }

    public List<String> getCapturedCanonicalMethodNameListWithMergedHierarchyCalls(Object stub) {
        ArrayList<String> retlist = new ArrayList<String>();
        List<String> capturedCanonicalMethodNameList = this.getCapturedCanonicalMethodNameList(stub);
        if (capturedCanonicalMethodNameList != null) {
            this.mergeHierarchicalNameList(capturedCanonicalMethodNameList);
            retlist.addAll(capturedCanonicalMethodNameList);
        }
        return retlist;
    }

    protected void mergeHierarchicalNameList(List<String> hierarchicalNameList) {
        ArrayList<String> hierarchicalNameListReversed = new ArrayList<String>(hierarchicalNameList);
        Collections.reverse(hierarchicalNameListReversed);
        hierarchicalNameList.clear();
        String methodNameLast = null;
        for (String methodName : hierarchicalNameListReversed) {
            if (methodNameLast == null || !StringUtils.startsWith((CharSequence)methodNameLast, (CharSequence)(methodName + "."))) {
                hierarchicalNameList.add(methodName);
            }
            methodNameLast = methodName;
        }
        Collections.reverse(hierarchicalNameList);
    }

    protected void mergeHierarchicalMethodCallCaptureContextList(List<MethodCallCaptureContext> hierarchicalMethodCallCaptureContextList) {
        ArrayList<MethodCallCaptureContext> hierarchicalMethodCallCaptureContextReversedList = new ArrayList<MethodCallCaptureContext>(hierarchicalMethodCallCaptureContextList);
        Collections.reverse(hierarchicalMethodCallCaptureContextReversedList);
        hierarchicalMethodCallCaptureContextList.clear();
        MethodCallCaptureContext methodCallCaptureContextLast = null;
        for (MethodCallCaptureContext methodCallCaptureContext : hierarchicalMethodCallCaptureContextReversedList) {
            MethodCallCaptureContext previousMethodCallCaptureContextFromLast;
            MethodCallCaptureContext methodCallCaptureContext2 = previousMethodCallCaptureContextFromLast = methodCallCaptureContextLast != null ? methodCallCaptureContextLast.getPreviousMethodCallCaptureContext() : null;
            if (methodCallCaptureContextLast == null || !methodCallCaptureContext.equals(previousMethodCallCaptureContextFromLast)) {
                hierarchicalMethodCallCaptureContextList.add(methodCallCaptureContext);
            }
            methodCallCaptureContextLast = methodCallCaptureContext;
        }
        Collections.reverse(hierarchicalMethodCallCaptureContextList);
    }

    public <E> ReplayResult replay(E object) {
        return this.replay(this.lastActiveRootStub, object);
    }

    public <E> ReplayResult replay(E stub, E object) {
        ReplayResult result = new ReplayResult();
        if (stub != null && object != null) {
            IdentityHashMap<Object, Object> stubToObjectMap = new IdentityHashMap<Object, Object>();
            stubToObjectMap.put(stub, object);
            try {
                List<MethodCallCaptureContext> methodCallCaptureContextList = this.getMethodCallCaptureContextList(stub);
                for (MethodCallCaptureContext methodCallCaptureContext : methodCallCaptureContextList) {
                    Object invocationStub;
                    Object invocationObject;
                    MethodCallCapture methodCallCapture;
                    if (methodCallCaptureContext == null || (methodCallCapture = methodCallCaptureContext.getMethodCallCapture()) == null || (invocationObject = stubToObjectMap.get(invocationStub = methodCallCapture.getObject())) == null) continue;
                    Method method = methodCallCapture.getMethod();
                    Object[] args = methodCallCapture.getArguments();
                    if (method == null) continue;
                    Object methodInvocationResult = method.invoke(invocationObject, args);
                    Object returnedStub = methodCallCaptureContext.getReturnedStub();
                    if (returnedStub == null || methodInvocationResult == null) continue;
                    stubToObjectMap.put(returnedStub, methodInvocationResult);
                }
                result.setReplaySuccessful(true);
            }
            catch (Exception exception) {
                result.setException(exception);
            }
        }
        return result;
    }

    private void addMethodCallCapture(MethodCallCaptureContext methodCallCaptureContext) {
        List<Object> stubList = methodCallCaptureContext.getStubList();
        for (Object stub : stubList) {
            this.getOrCreateMethodCallCaptureContextListForStub(stub).add(methodCallCaptureContext);
        }
        this.lastActiveRootStub = stubList.get(0);
    }

    public static class ReplayResult {
        protected Exception exception = null;
        protected boolean isReplaySuccessful = false;

        public boolean isReplaySuccessful() {
            return this.isReplaySuccessful;
        }

        public Exception getException() {
            return this.exception;
        }

        protected void setException(Exception exception) {
            this.exception = exception;
        }

        protected void setReplaySuccessful(boolean isReplaySuccessful) {
            this.isReplaySuccessful = isReplaySuccessful;
        }
    }

    public static class MethodCallCaptureContext {
        protected MethodCallCapture methodCallCapture = null;
        protected MethodCallCaptureContext previousMethodCallCaptureContext = null;
        protected Object returnedStub = null;

        public MethodCallCaptureContext(MethodCallCapture methodCallCapture, MethodCallCaptureContext previousMethodCallCaptureContext) {
            this.methodCallCapture = methodCallCapture;
            this.previousMethodCallCaptureContext = previousMethodCallCaptureContext;
        }

        public MethodCallCapture getMethodCallCapture() {
            return this.methodCallCapture;
        }

        public List<MethodCallCapture> determineCanonicalMethodCallCaptures(Object rootStub) {
            ArrayList<MethodCallCapture> retlist = new ArrayList<MethodCallCapture>();
            if (this.previousMethodCallCaptureContext == null) {
                retlist.add(this.methodCallCapture);
            } else if (this.getStub() != rootStub) {
                retlist.addAll(this.previousMethodCallCaptureContext.determineCanonicalMethodCallCaptures(rootStub));
                retlist.add(this.methodCallCapture);
            }
            return retlist;
        }

        public String determineCanonicalMethodName(Object rootStub) {
            String retval = null;
            List<MethodCallCapture> canonicalMethodCallCaptureList = this.determineCanonicalMethodCallCaptures(rootStub);
            for (MethodCallCapture methodCallCapture : canonicalMethodCallCaptureList) {
                String methodName = methodCallCapture.getMethodName();
                retval = retval == null ? methodName : retval + "." + methodName;
            }
            return retval;
        }

        public String determineCanonicalPropertyName(Object rootStub) {
            String retval = null;
            List<MethodCallCapture> canonicalMethodCallCaptureList = this.determineCanonicalMethodCallCaptures(rootStub);
            for (MethodCallCapture methodCallCapture : canonicalMethodCallCaptureList) {
                BeanMethodInformation beanMethodInformation;
                Method method = methodCallCapture.getMethod();
                if (method == null || (beanMethodInformation = BeanUtils.beanMethodInformation(method)) == null) continue;
                String referencedFieldName = beanMethodInformation.getPropertyName();
                retval = retval == null ? referencedFieldName : retval + "." + referencedFieldName;
            }
            return retval;
        }

        public Object getStub() {
            return this.methodCallCapture != null ? this.methodCallCapture.getObject() : null;
        }

        public List<Object> getStubList() {
            ArrayList<Object> retlist = new ArrayList<Object>();
            if (this.previousMethodCallCaptureContext != null) {
                retlist.addAll(this.previousMethodCallCaptureContext.getStubList());
            }
            retlist.add(this.getStub());
            return retlist;
        }

        protected Object getReturnedStub() {
            return this.returnedStub;
        }

        protected void setReturnedStub(Object returnedStub) {
            this.returnedStub = returnedStub;
        }

        public MethodCallCaptureContext getPreviousMethodCallCaptureContext() {
            return this.previousMethodCallCaptureContext;
        }
    }

    protected static class CapturedTypeInstanceCreationConfiguration {
        protected Class<?> type = null;
        protected Class<?>[] interfaces = null;
        protected boolean isCreatingTransitiveStubs = false;
        protected MethodCallCaptureContext previousMethodCallCaptureContext = null;

        public CapturedTypeInstanceCreationConfiguration(Class<?> type, Class<?>[] interfaces, boolean isCreatingTransitiveStubs) {
            this.type = type;
            this.interfaces = interfaces;
            this.isCreatingTransitiveStubs = isCreatingTransitiveStubs;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }

        public void setInterfaces(Class<?>[] interfaces) {
            this.interfaces = interfaces;
        }

        public boolean isCreatingTransitiveStubs() {
            return this.isCreatingTransitiveStubs;
        }

        public void setCreatingTransitiveStubs(boolean isCreatingTransitiveStubs) {
            this.isCreatingTransitiveStubs = isCreatingTransitiveStubs;
        }

        protected boolean isMethodCallCapturerAware() {
            return this.interfaces != null && ArrayUtils.contains((Object[])this.interfaces, MethodCallCapturerAware.class);
        }

        protected MethodCallCaptureContext getPreviousMethodCallCaptureContext() {
            return this.previousMethodCallCaptureContext;
        }

        protected void setPreviousMethodCallCaptureContext(MethodCallCaptureContext previousMethodCallCaptureContext) {
            this.previousMethodCallCaptureContext = previousMethodCallCaptureContext;
        }
    }

    protected class MethodCaptureMethodInvocationHandler
    implements MethodInvocationHandler {
        protected CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration = null;

        public MethodCaptureMethodInvocationHandler(CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration) {
            this.capturedTypeInstanceCreationConfiguration = capturedTypeInstanceCreationConfiguration;
        }

        @Override
        public Object handle(MethodCallCapture methodCallCapture) {
            Object retval = null;
            String methodName = methodCallCapture.getMethod().getName();
            if (this.capturedTypeInstanceCreationConfiguration.isMethodCallCapturerAware() && "getMethodCallCapturer".equals(methodName)) {
                retval = MethodCallCapturer.this;
            } else if ("getCapturedType".equals(methodName)) {
                retval = this.capturedTypeInstanceCreationConfiguration.getType();
            } else if ("toString".equals(methodName)) {
                retval = "Capturer proxy for " + String.valueOf(this.capturedTypeInstanceCreationConfiguration.getType());
            } else {
                Method method = methodCallCapture.getMethod();
                if (method != null) {
                    Class<?> returnType;
                    MethodCallCaptureContext methodCallCaptureContext = new MethodCallCaptureContext(methodCallCapture, this.capturedTypeInstanceCreationConfiguration.getPreviousMethodCallCaptureContext());
                    if (this.capturedTypeInstanceCreationConfiguration.isCreatingTransitiveStubs() && (returnType = method.getReturnType()) != null && Object.class.isAssignableFrom(returnType)) {
                        CapturedTypeInstanceCreationConfiguration capturedTypeInstanceCreationConfiguration = new CapturedTypeInstanceCreationConfiguration(returnType, this.capturedTypeInstanceCreationConfiguration.getInterfaces(), this.capturedTypeInstanceCreationConfiguration.isCreatingTransitiveStubs());
                        capturedTypeInstanceCreationConfiguration.setPreviousMethodCallCaptureContext(methodCallCaptureContext);
                        retval = MethodCallCapturer.this.newInstanceOfCapturedType(capturedTypeInstanceCreationConfiguration);
                        methodCallCaptureContext.setReturnedStub(retval);
                    }
                    MethodCallCapturer.this.addMethodCallCapture(methodCallCaptureContext);
                }
            }
            return retval;
        }
    }

    public static interface TypeCaptureAware {
        public Class<?> getCapturedType();
    }

    public static interface MethodCallCapturerAware {
        public MethodCallCapturer getMethodCallCapturer();
    }
}

