/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.proxy;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.omnaest.utils.operation.foreach.Range;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ElementStream;
import org.omnaest.utils.structure.element.KeyExtractor;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.iterator.ElementStreamToIteratorAdapter;
import org.omnaest.utils.structure.iterator.RangedIterable;
import org.omnaest.utils.structure.map.MapUtils;

public class MethodInvocationForwardingCapturer {
    public static <T> T newProxyInstanceCapturing(T object, OutputStream outputStream) {
        T retval = null;
        if (object != null) {
            ForwardingMethodInvocationHandler methodInvocationHandler = new ForwardingMethodInvocationHandler(object, outputStream);
            Class<?> type = object.getClass();
            Class<?>[] interfaces = type.getInterfaces();
            retval = (T)StubCreator.newStubInstance(type, interfaces, methodInvocationHandler);
        }
        return retval;
    }

    public static void closeCapturingOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.append("</object-stream>");
                outputStreamWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T newProxyInstanceReplaying(Class<T> type, InputStream inputStream, boolean ignoreArgumentValues) {
        Range range = null;
        return MethodInvocationForwardingCapturer.newProxyInstanceReplaying(type, inputStream, ignoreArgumentValues, range);
    }

    public static <T> T newProxyInstanceReplaying(Class<T> type, InputStream inputStream, final boolean ignoreArgumentValues, Range range) {
        T retval = null;
        if (type != null) {
            KeyExtractor<MethodInvocationComparison, MethodInvocationAndResult> keyExtractor = new KeyExtractor<MethodInvocationComparison, MethodInvocationAndResult>(){

                @Override
                public MethodInvocationComparison extractKey(MethodInvocationAndResult methodInvocationAndResult) {
                    MethodInvocationComparison key = null;
                    if (methodInvocationAndResult != null) {
                        Method method = methodInvocationAndResult.getMethod();
                        Object[] arguments = methodInvocationAndResult.getArguments();
                        key = ignoreArgumentValues ? new MethodOnly(method) : new MethodAndArguments(method, arguments);
                    }
                    return key;
                }
            };
            ElementConverter<MethodInvocationAndResult, Object> valueElementConverter = new ElementConverter<MethodInvocationAndResult, Object>(){

                @Override
                public Object convert(MethodInvocationAndResult methodInvocationAndResult) {
                    return methodInvocationAndResult.getResult();
                }
            };
            Iterable<MethodInvocationAndResult> iterable = MethodInvocationForwardingCapturer.newMethodInvocationAndResultIterable(inputStream, range);
            Map<MethodInvocationComparison, Object> methodInvocationComparisonToResultMap = MapUtils.convertMapValue(ListUtils.toMap(keyExtractor, iterable), valueElementConverter);
            ReplayingMethodInvocationHandler methodInvocationHandler = new ReplayingMethodInvocationHandler(methodInvocationComparisonToResultMap);
            Class<?>[] interfaces = type.getInterfaces();
            retval = StubCreator.newStubInstance(type, interfaces, methodInvocationHandler);
        }
        return retval;
    }

    public static void replayOn(InputStream inputStream, Object object, Range ... ranges) {
        if (inputStream != null && object != null) {
            Class<?> type = object.getClass();
            Iterable<MethodInvocationAndResult> methodInvocationAndResultIterable = MethodInvocationForwardingCapturer.newMethodInvocationAndResultIterable(inputStream);
            if (methodInvocationAndResultIterable != null) {
                long indexPosition = 0L;
                for (MethodInvocationAndResult methodInvocationAndResult : methodInvocationAndResultIterable) {
                    boolean isWithinRange;
                    boolean bl = isWithinRange = ranges.length == 0;
                    if (!isWithinRange) {
                        for (Range range : ranges) {
                            if (!range.isWithinRange(indexPosition)) continue;
                            isWithinRange = true;
                            break;
                        }
                    }
                    if (isWithinRange) {
                        try {
                            Method method = methodInvocationAndResult.getMethod();
                            Object[] args = methodInvocationAndResult.getArguments();
                            Method declaredMethod = type.getDeclaredMethod(method.getName(), method.getParameterTypes());
                            declaredMethod.invoke(object, args);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++indexPosition;
                }
            }
        }
    }

    protected static XStream newXStream() {
        XStream xStream = new XStream();
        xStream.processAnnotations(MethodInvocationAndResult.class);
        return xStream;
    }

    public static ElementStream<MethodInvocationAndResult> newMethodInvocationAndResultElementStream(InputStream inputStream) {
        ElementStream<MethodInvocationAndResult> retval = null;
        XStream xStream = MethodInvocationForwardingCapturer.newXStream();
        try {
            final ObjectInputStream objectInputStream = xStream.createObjectInputStream(inputStream);
            retval = new ElementStream<MethodInvocationAndResult>(){

                @Override
                public MethodInvocationAndResult next() {
                    MethodInvocationAndResult retval = null;
                    try {
                        retval = (MethodInvocationAndResult)objectInputStream.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return retval;
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retval;
    }

    protected static Iterator<MethodInvocationAndResult> newMethodInvocationAndResultIterator(InputStream inputStream) {
        return new ElementStreamToIteratorAdapter<MethodInvocationAndResult>(MethodInvocationForwardingCapturer.newMethodInvocationAndResultElementStream(inputStream));
    }

    public static Iterable<MethodInvocationAndResult> newMethodInvocationAndResultIterable(final InputStream inputStream) {
        return new Iterable<MethodInvocationAndResult>(){

            @Override
            public Iterator<MethodInvocationAndResult> iterator() {
                return MethodInvocationForwardingCapturer.newMethodInvocationAndResultIterator(inputStream);
            }
        };
    }

    public static Iterable<MethodInvocationAndResult> newMethodInvocationAndResultIterable(InputStream inputStream, Range range) {
        RangedIterable iterable = MethodInvocationForwardingCapturer.newMethodInvocationAndResultIterable(inputStream);
        return range != null ? new RangedIterable(range, iterable) : iterable;
    }

    private MethodInvocationForwardingCapturer(OutputStream outputStream) {
    }

    protected static class ForwardingMethodInvocationHandler
    implements MethodInvocationHandler {
        private Object object = null;
        private XStream xStream = new XStream();
        private ObjectOutputStream objectOutputStream = null;

        public ForwardingMethodInvocationHandler(Object object, OutputStream outputStream) {
            this.object = object;
            try {
                this.objectOutputStream = this.xStream.createObjectOutputStream(outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.xStream.processAnnotations(MethodInvocationAndResult.class);
        }

        @Override
        public Object handle(MethodCallCapture methodCallCapture) throws Throwable {
            Object retval = null;
            Object[] arguments = methodCallCapture.getArguments();
            retval = methodCallCapture.getProxy().invoke(this.object, arguments);
            try {
                Method method = methodCallCapture.getMethod();
                MethodInvocationAndResult methodInvocationAndResult = new MethodInvocationAndResult(method, arguments, retval);
                this.objectOutputStream.writeObject(methodInvocationAndResult);
                this.objectOutputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return retval;
        }
    }

    protected static class ReplayingMethodInvocationHandler
    implements MethodInvocationHandler {
        private Map<MethodInvocationComparison, Object> methodInvocationComparisonToResultMap = null;

        public ReplayingMethodInvocationHandler(Map<MethodInvocationComparison, Object> methodInvocationComparisonToResultMap) {
            this.methodInvocationComparisonToResultMap = methodInvocationComparisonToResultMap;
        }

        @Override
        public Object handle(MethodCallCapture methodCallCapture) throws Throwable {
            Object retval = null;
            Method method = methodCallCapture.getMethod();
            Object[] arguments = methodCallCapture.getArguments();
            MethodAndArguments methodAndArguments = new MethodAndArguments(method, arguments);
            MethodOnly methodOnly = new MethodOnly(method);
            if (this.methodInvocationComparisonToResultMap.containsKey(methodAndArguments)) {
                retval = this.methodInvocationComparisonToResultMap.get(methodAndArguments);
            } else if (this.methodInvocationComparisonToResultMap.containsKey(methodOnly)) {
                retval = this.methodInvocationComparisonToResultMap.get(methodOnly);
            }
            return retval;
        }
    }

    protected static class MethodAndArguments
    implements MethodInvocationComparison {
        private Method method = null;
        private Object[] arguments = null;

        public MethodAndArguments(Method method, Object[] arguments) {
            this.method = method;
            this.arguments = arguments;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.arguments);
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodAndArguments)) {
                return false;
            }
            MethodAndArguments other = (MethodAndArguments)obj;
            if (!Arrays.equals(this.arguments, other.arguments)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\nMethodAndArguments [method=");
            builder.append(this.method);
            builder.append(", arguments=");
            builder.append(Arrays.toString(this.arguments));
            builder.append("]");
            return builder.toString();
        }
    }

    protected static class MethodOnly
    implements MethodInvocationComparison {
        private Method method = null;

        public MethodOnly(Method method) {
            this.method = method;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodOnly)) {
                return false;
            }
            MethodOnly other = (MethodOnly)obj;
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodOnly [method=");
            builder.append(this.method);
            builder.append("]");
            return builder.toString();
        }
    }

    protected static interface MethodInvocationComparison {
        public boolean equals(Object var1);

        public int hashCode();
    }

    @XStreamAlias(value="methodInvocation")
    public static class MethodInvocationAndResult {
        private Method method = null;
        private Object[] arguments = null;
        private Object result = null;

        public MethodInvocationAndResult(Method method, Object[] arguments, Object result) {
            this.method = method;
            this.arguments = arguments;
            this.result = result;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Object getResult() {
            return this.result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodInvocationAndResult [method=");
            builder.append(this.method);
            builder.append(", arguments=");
            builder.append(Arrays.toString(this.arguments));
            builder.append(", result=");
            builder.append(this.result);
            builder.append("]");
            return builder.toString();
        }
    }
}

