/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;

public class StubCreator<E> {
    private final Factory factory;

    public StubCreator(Class<? extends E> type) {
        this(type, (Class[])null);
    }

    public StubCreator(Class<? extends E> type, ExceptionHandler exceptionHandler) {
        this(type, null, exceptionHandler);
    }

    public StubCreator(Class<? extends E> type, Class<?>[] interfaces) {
        this(type, interfaces, new ExceptionHandlerIgnoring());
    }

    public StubCreator(Class<? extends E> type, Class<?>[] interfaces, ExceptionHandler exceptionHandler) {
        MethodInvocationHandler methodInvocationHandler = null;
        this.factory = (Factory)StubCreator.newStubInstance(type, interfaces, methodInvocationHandler, exceptionHandler);
        Assert.isNotNull((Object)this.factory, "Failed to create a stub factory");
    }

    public E build(MethodInvocationHandler methodInvocationHandler) {
        Object retval = null;
        MethodInterceptor callback = StubCreator.adapter(methodInvocationHandler);
        retval = this.factory.newInstance((Callback)callback);
        return (E)retval;
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, MethodInvocationHandler methodInvocationHandler) {
        return StubCreator.newStubInstance(clazz, null, methodInvocationHandler);
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, MethodInterceptor methodInterceptor) {
        return StubCreator.newStubInstance(clazz, null, methodInterceptor);
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, Class<?>[] interfaces, MethodInvocationHandler methodInvocationHandler) {
        return StubCreator.newStubInstance(clazz, interfaces, StubCreator.adapter(methodInvocationHandler));
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, Class<?>[] interfaces, MethodInvocationHandler methodInvocationHandler, ExceptionHandler exceptionHandler) {
        return StubCreator.newStubInstance(clazz, interfaces, StubCreator.adapter(methodInvocationHandler), exceptionHandler);
    }

    protected static MethodInterceptor adapter(final MethodInvocationHandler methodInvocationHandler) {
        return new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return methodInvocationHandler.handle(new MethodCallCapture(obj, method, args, proxy));
            }
        };
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, Class<?>[] interfaces, MethodInterceptor methodInterceptor) {
        ExceptionHandler exceptionHandler = null;
        return StubCreator.newStubInstance(clazz, interfaces, methodInterceptor, exceptionHandler);
    }

    public static <E> E newStubInstance(Class<? extends E> clazz, Class<?>[] interfaces, MethodInterceptor methodInterceptor, ExceptionHandler exceptionHandler) {
        Object retval;
        block7: {
            retval = null;
            if (clazz != null && methodInterceptor != null) {
                try {
                    HashSet interfaceSet = new HashSet();
                    if (interfaces != null) {
                        interfaceSet.addAll(Arrays.asList(interfaces));
                    }
                    if (clazz.isInterface()) {
                        interfaceSet.add(clazz);
                    }
                    Enhancer enhancer = new Enhancer();
                    if (interfaceSet.size() > 0) {
                        enhancer.setInterfaces(interfaceSet.toArray(new Class[0]));
                    }
                    if (!clazz.isInterface()) {
                        enhancer.setSuperclass(clazz);
                    }
                    enhancer.setCallback((Callback)methodInterceptor);
                    retval = enhancer.create();
                }
                catch (Exception e) {
                    if (exceptionHandler == null) break block7;
                    exceptionHandler.handleException(e);
                }
            }
        }
        return (E)retval;
    }
}

