/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToClassOfObject;
import org.omnaest.utils.structure.element.factory.concrete.LinkedHashSetFactory;
import org.omnaest.utils.structure.map.MapUtils;

public class ReflectionUtils {
    public static int declaredMethodIndexPosition(Class<?> clazz, Method method) {
        Object[] declaredMethods;
        int retval = -1;
        if (clazz != null && method != null && (declaredMethods = clazz.getDeclaredMethods()) != null) {
            retval = ArrayUtils.indexOf((Object[])declaredMethods, (Object)method);
        }
        return retval;
    }

    public static int declaredFieldIndexPosition(Class<?> clazz, Field field) {
        Object[] declaredFields;
        int retval = -1;
        if (clazz != null && field != null && (declaredFields = clazz.getDeclaredFields()) != null) {
            retval = ArrayUtils.indexOf((Object[])declaredFields, (Object)field);
        }
        return retval;
    }

    public static int declaredFieldIndexPosition(Class<?> clazz, String fieldname) {
        int retval = -1;
        if (clazz != null && fieldname != null) {
            try {
                Object[] declaredFields;
                Field field = clazz.getField(fieldname);
                if (field != null && (declaredFields = clazz.getDeclaredFields()) != null) {
                    retval = ArrayUtils.indexOf((Object[])declaredFields, (Object)field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int numberOfDeclaredFields(Class<?> clazz) {
        return clazz != null ? clazz.getDeclaredFields().length : 0;
    }

    public static int numberOfDeclaredMethods(Class<?> clazz) {
        return clazz != null ? clazz.getDeclaredMethods().length : 0;
    }

    public static <B> boolean hasConstructorFor(Class<? extends B> type, Object ... arguments) {
        return ReflectionUtils.constructorFor(type, arguments) != null;
    }

    public static <B> boolean hasConstructorFor(Class<? extends B> type, Class<?> ... parameterTypes) {
        return ReflectionUtils.constructorFor(type, parameterTypes) != null;
    }

    public static <B> boolean hasDefaultConstructorFor(Class<? extends B> type) {
        return ReflectionUtils.hasConstructorFor(type, new Class[0]);
    }

    public static <B> Constructor<B> constructorFor(Class<? extends B> type, Object ... arguments) {
        Class<?>[] parameterTypes = ReflectionUtils.determineParameterTypesFromArguments(arguments);
        return ReflectionUtils.constructorFor(type, parameterTypes);
    }

    private static Class<?>[] determineParameterTypesFromArguments(Object ... arguments) {
        return ListUtils.convert(Arrays.asList(arguments), new ElementConverterObjectToClassOfObject()).toArray(new Class[arguments.length]);
    }

    public static <B> Constructor<B> constructorFor(Class<? extends B> type, Class<?> ... parameterTypes) {
        Constructor<? extends B> constructor = null;
        try {
            constructor = type.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            try {
                constructor = type.getConstructor(parameterTypes);
            }
            catch (Exception e2) {
                try {
                    constructor = ReflectionUtils.resolveConstructorFor(type, parameterTypes);
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return constructor;
    }

    public static <C> Constructor<C> resolveConstructorFor(Class<C> type, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        Constructor<?> retval = null;
        if (type != null && (constructors = type.getConstructors()) != null) {
            for (Constructor<?> constructor : constructors) {
                Class<?>[] parameterTypesOfContstructor = constructor.getParameterTypes();
                boolean areConstructorTypesAssignableFromParameterTypes = ReflectionUtils.areAssignableFrom(parameterTypesOfContstructor, parameterTypes);
                if (!areConstructorTypesAssignableFromParameterTypes) continue;
                retval = constructor;
                break;
            }
        }
        return retval;
    }

    public static boolean areAssignableFrom(Class<?>[] assignableTypes, Class<?>[] sourceTypes) {
        boolean retval;
        boolean bl = retval = assignableTypes != null && sourceTypes != null && assignableTypes.length == sourceTypes.length;
        if (retval) {
            Class<?> sourceType;
            Class<?> assignableType;
            for (int ii = 0; ii < assignableTypes.length && (retval &= (assignableType = assignableTypes[ii]).isAssignableFrom(sourceType = sourceTypes[ii])); ++ii) {
            }
        }
        return retval;
    }

    public static <B> B newInstanceOf(Class<? extends B> type, Object ... arguments) {
        B retval = null;
        if (type != null) {
            try {
                Constructor<B> constructor = ReflectionUtils.constructorFor(type, arguments);
                constructor.setAccessible(true);
                retval = constructor.newInstance(arguments);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static <B> B newInstanceByValueOf(Class<? extends B> type, Object ... arguments) {
        Object retval = null;
        if (type != null) {
            Class<?>[] parameterTypes = ReflectionUtils.determineParameterTypesFromArguments(arguments);
            try {
                String name = "valueOf";
                Method valueOfMethod = type.getDeclaredMethod("valueOf", parameterTypes);
                valueOfMethod.setAccessible(true);
                retval = valueOfMethod.invoke(null, arguments);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (B)retval;
    }

    public static Map<Method, Class<?>> declaredMethodToReturnTypeMap(Class<?> type) {
        List<Method> methodList = ReflectionUtils.declaredMethodList(type);
        return ReflectionUtils.methodToReturnTypeMap(methodList);
    }

    public static Map<Method, Class<?>> methodToReturnTypeMap(Class<?> type) {
        List<Method> methodList = ReflectionUtils.methodList(type);
        return ReflectionUtils.methodToReturnTypeMap(methodList);
    }

    protected static Map<Method, Class<?>> methodToReturnTypeMap(List<Method> methodList) {
        LinkedHashMap retmap = new LinkedHashMap();
        if (methodList != null) {
            for (Method method : methodList) {
                Class<?> returnType = method.getReturnType();
                retmap.put(method, returnType);
            }
        }
        return retmap;
    }

    public static <A extends Annotation> Map<Method, A> methodToAnnotationMap(Class<?> type, final Class<A> annotationType) {
        Map retmap = null;
        Map<Method, Set<Annotation>> methodToAnnotationSetMap = ReflectionUtils.methodToAnnotationSetMap(type);
        ElementConverter valueElementConverter = new ElementConverter<Set<Annotation>, A>(){

            @Override
            public A convert(Set<Annotation> annotationSet) {
                Annotation retval = null;
                if (annotationSet != null) {
                    for (Annotation annotation : annotationSet) {
                        if (annotation == null || !annotationType.isAssignableFrom(annotation.getClass())) continue;
                        retval = annotation;
                        break;
                    }
                }
                return retval;
            }
        };
        retmap = MapUtils.convertMapValue(methodToAnnotationSetMap, valueElementConverter);
        retmap = MapUtils.filteredMapExcludingNullValues(retmap);
        return retmap;
    }

    public static List<Annotation> declaredAnnotationList(Class<?> type) {
        ArrayList<Annotation> retlist = new ArrayList<Annotation>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getDeclaredAnnotations()));
        }
        return retlist;
    }

    public static List<Annotation> annotationList(Class<?> type) {
        ArrayList<Annotation> retlist = new ArrayList<Annotation>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getAnnotations()));
        }
        return retlist;
    }

    public static List<Annotation> annotationList(Field field) {
        ArrayList<Annotation> retlist = new ArrayList<Annotation>();
        if (field != null) {
            retlist.addAll(Arrays.asList(field.getAnnotations()));
        }
        return retlist;
    }

    public static <A extends Annotation> A annotationIncludingInterfaces(Class<?> type, Class<? extends A> annotationType) {
        Annotation retval = null;
        List<Annotation> annotationList = ReflectionUtils.annotationList(type);
        for (Annotation annotation : annotationList) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            retval = annotation;
            break;
        }
        if (retval == null) {
            boolean inherited = true;
            Set<Class<?>> interfaceSet = ReflectionUtils.interfaceSet(type, true);
            for (Class<?> interfaceType : interfaceSet) {
                A declaredAnnotation = ReflectionUtils.declaredAnnotation(interfaceType, annotationType);
                if (declaredAnnotation == null) continue;
                retval = declaredAnnotation;
                break;
            }
        }
        return (A)retval;
    }

    public static boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.annotation(type, annotationType) != null;
    }

    public static <A extends Annotation> A annotation(Package package_, Class<? extends A> annotationType) {
        A retval = null;
        if (package_ != null) {
            retval = package_.getAnnotation(annotationType);
        }
        return retval;
    }

    public static <A extends Annotation> A annotation(Class<?> type, Class<? extends A> annotationType) {
        Annotation retval = null;
        if (type != null && annotationType != null) {
            List<Annotation> annotationList = ReflectionUtils.annotationList(type);
            for (Annotation annotation : annotationList) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                retval = annotation;
                break;
            }
        }
        return (A)retval;
    }

    public static boolean hasAnnotation(Field field, Class<? extends Annotation> annotationType) {
        boolean retval = false;
        List<Annotation> annotationList = ReflectionUtils.annotationList(field);
        for (Annotation annotation : annotationList) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static boolean hasAnnotationIncludingInterfaces(Class<?> type, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.annotationIncludingInterfaces(type, annotationType) != null;
    }

    public static boolean hasDeclaredAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.declaredAnnotation(type, annotationType) != null;
    }

    public static <A extends Annotation> A declaredAnnotation(Class<?> type, Class<? extends A> annotationType) {
        Annotation retval = null;
        if (type != null && annotationType != null) {
            List<Annotation> declaredAnnotationList = ReflectionUtils.declaredAnnotationList(type);
            for (Annotation declaredAnnotation : declaredAnnotationList) {
                if (!declaredAnnotation.annotationType().equals(annotationType)) continue;
                retval = declaredAnnotation;
                break;
            }
        }
        return (A)retval;
    }

    public static boolean hasDeclaredAnnotation(Method method, Class<? extends Annotation> annotationType) {
        boolean retval = false;
        Set<Annotation> declaredAnnotationSet = ReflectionUtils.declaredAnnotationSet(method);
        for (Annotation declaredAnnotation : declaredAnnotationSet) {
            if (!declaredAnnotation.annotationType().equals(annotationType)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static boolean hasAnnotationOnAnyMethod(Class<?> type, Class<? extends Annotation> annotationType) {
        return ReflectionUtils.hasAnnotationOnAnyMethod(annotationType, new Class[]{annotationType});
    }

    public static boolean hasAnnotationOnAnyMethod(Class<?> type, Class<? extends Annotation> ... annotationTypes) {
        Method[] methods;
        boolean retval = false;
        if (type != null && annotationTypes != null && (methods = type.getMethods()) != null) {
            block0: for (Method method : methods) {
                for (Class<? extends Annotation> annotationType : annotationTypes) {
                    Annotation annotation = method.getAnnotation(annotationType);
                    if (annotation == null) continue;
                    retval = true;
                    continue block0;
                }
            }
        }
        return retval;
    }

    public static Set<Annotation> declaredAnnotationSet(AnnotatedElement annotatedElement) {
        return annotatedElement != null ? SetUtils.valueOf(annotatedElement.getDeclaredAnnotations()) : new LinkedHashSet();
    }

    public static Map<Class<Annotation>, Annotation> annotationTypeToAnnotationMap(AnnotatedElement annotatedElement) {
        LinkedHashMap<Class<Annotation>, Annotation> retmap = new LinkedHashMap<Class<Annotation>, Annotation>();
        if (annotatedElement != null) {
            Set<Annotation> annotationSet = SetUtils.valueOf(annotatedElement.getAnnotations());
            for (Annotation annotation : annotationSet) {
                if (annotation == null) continue;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                retmap.put(annotationType, annotation);
            }
        }
        return retmap;
    }

    public static Map<Method, Set<Annotation>> methodToAnnotationSetMap(Class<?> type) {
        List<Method> methodList = ReflectionUtils.methodList(type);
        return ReflectionUtils.methodToAnnotationSetMap(methodList);
    }

    public static Map<Method, Set<Annotation>> declaredMethodToAnnotationSetMap(Class<?> type) {
        List<Method> methodList = ReflectionUtils.declaredMethodList(type);
        return ReflectionUtils.methodToAnnotationSetMap(methodList);
    }

    protected static Map<Method, Set<Annotation>> methodToAnnotationSetMap(List<Method> methodList) {
        LinkedHashMap<Method, Set<Annotation>> retmap = new LinkedHashMap<Method, Set<Annotation>>();
        if (methodList != null) {
            for (Method declaredMethod : methodList) {
                Set<Annotation> declaredAnnotationSet = ReflectionUtils.declaredAnnotationSet(declaredMethod);
                if (declaredAnnotationSet == null) continue;
                retmap.put(declaredMethod, declaredAnnotationSet);
            }
        }
        return retmap;
    }

    public static List<MethodParameterMetaInformation> declaredMethodParameterMetaInformationList(Method method) {
        ArrayList<MethodParameterMetaInformation> retlist = new ArrayList<MethodParameterMetaInformation>();
        if (method != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parametersAnnotations = method.getParameterAnnotations();
            for (int ii = 0; ii < Math.max(parameterTypes.length, parametersAnnotations.length); ++ii) {
                Class<?> parameterType = parameterTypes[ii];
                Annotation[] parameterAnnotations = parametersAnnotations[ii];
                MethodParameterMetaInformation methodParameterMetaInformation = new MethodParameterMetaInformation(parameterType, Arrays.asList(parameterAnnotations));
                retlist.add(methodParameterMetaInformation);
            }
        }
        return retlist;
    }

    public static List<Method> declaredMethodList(Class<?> type) {
        ArrayList<Method> retlist = new ArrayList<Method>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getDeclaredMethods()));
        }
        return retlist;
    }

    public static List<Field> declaredFieldList(Class<?> type) {
        ArrayList<Field> retlist = new ArrayList<Field>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getDeclaredFields()));
        }
        return retlist;
    }

    public static List<Field> fieldList(Class<?> type) {
        ArrayList<Field> retlist = new ArrayList<Field>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getFields()));
        }
        return retlist;
    }

    public static List<Method> methodList(Class<?> type) {
        ArrayList<Method> retlist = new ArrayList<Method>();
        if (type != null) {
            retlist.addAll(Arrays.asList(type.getMethods()));
        }
        return retlist;
    }

    public static List<Method> methodListIncludingSuperMethods(Class<?> type) {
        ArrayList<Method> retlist = new ArrayList<Method>();
        if (type != null) {
            boolean inherited = true;
            Set<Class<?>> assignableTypeSet = ReflectionUtils.assignableTypeSet(type, true);
            if (assignableTypeSet != null) {
                for (Class<?> assignableType : assignableTypeSet) {
                    retlist.addAll(ReflectionUtils.methodList(assignableType));
                }
            }
        }
        return retlist;
    }

    public static Set<Class<?>> interfaceSet(Class<?> type, boolean inherited) {
        boolean interfaceOnly = true;
        return ReflectionUtils.assignableTypeSet(type, inherited, interfaceOnly);
    }

    public static Set<Class<?>> assignableTypeSet(Class<?> type, boolean inherited) {
        boolean interfaceOnly = false;
        return ReflectionUtils.assignableTypeSet(type, inherited, interfaceOnly);
    }

    public static Set<Class<?>> assignableTypeSet(Class<?> type, boolean inherited, boolean onlyReturnInterfaces) {
        final LinkedHashSet retset = new LinkedHashSet();
        if (type != null) {
            final LinkedHashSet remainingTypeSet = new LinkedHashSet();
            if (!onlyReturnInterfaces || type.isInterface()) {
                retset.add(type);
            }
            if (inherited) {
                remainingTypeSet.addAll(ReflectionUtils.supertypeSet(type));
            }
            class Helper {
                Helper() {
                }

                public void addNewInterfaceTypes(Class<?> type) {
                    Class<?>[] interfaces = type.getInterfaces();
                    if (interfaces != null) {
                        for (Class<?> interfaceType : interfaces) {
                            if (retset.contains(interfaceType)) continue;
                            remainingTypeSet.add(interfaceType);
                        }
                    }
                }
            }
            Helper helper = new Helper();
            helper.addNewInterfaceTypes(type);
            while (!remainingTypeSet.isEmpty()) {
                Iterator iterator = remainingTypeSet.iterator();
                Class remainingType = (Class)iterator.next();
                iterator.remove();
                if (!onlyReturnInterfaces || remainingType.isInterface()) {
                    retset.add(remainingType);
                }
                if (!inherited) continue;
                helper.addNewInterfaceTypes(remainingType);
            }
        }
        return retset;
    }

    public static Set<Class<?>> supertypeSet(Class<?> type) {
        LinkedHashSet retset = new LinkedHashSet();
        if (type != null) {
            for (Class<?> supertype = type.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
                retset.add(supertype);
            }
        }
        return retset;
    }

    public static Set<Class<?>> assignableTypeSet(boolean inherited, boolean onlyReturnInterfaces, boolean intersection, Class<?> ... types) {
        Set<Class<Object>> retset = new HashSet();
        if (types.length > 0) {
            LinkedHashSet assignableTypeSetSet = new LinkedHashSet();
            for (Class<?> type : types) {
                if (type == null) continue;
                Set<Class<?>> assignableTypeSet = ReflectionUtils.assignableTypeSet(type, inherited, onlyReturnInterfaces);
                assignableTypeSetSet.add(assignableTypeSet);
            }
            retset = !intersection ? SetUtils.mergeAll(assignableTypeSetSet) : SetUtils.intersection(assignableTypeSetSet);
        }
        return retset;
    }

    public static boolean isAssignableFrom(Class<?> targetType, Class<?> type) {
        return type != null && targetType != null && targetType.isAssignableFrom(type);
    }

    public static <A extends Annotation> Set<Package> annotatedPackageSet(Class<? extends A> ... packageAnnotationTypes) {
        return ReflectionUtils.annotatedPackageToAnnotationSetMap(packageAnnotationTypes).keySet();
    }

    public static <A extends Annotation> Set<Package> annotatedPackageSet(Set<Package> scannedPackageSet, Class<? extends A> ... packageAnnotationTypes) {
        return ReflectionUtils.annotatedPackageToAnnotationSetMap(scannedPackageSet, packageAnnotationTypes).keySet();
    }

    public static <A extends Annotation> Map<Package, Set<A>> annotatedPackageToAnnotationSetMap(Class<? extends A> ... packageAnnotationTypes) {
        Set<Package> scannedPackageSet = SetUtils.valueOf(Package.getPackages());
        return ReflectionUtils.annotatedPackageToAnnotationSetMap(scannedPackageSet, packageAnnotationTypes);
    }

    public static <A extends Annotation> Map<Package, Set<A>> annotatedPackageToAnnotationSetMap(Set<Package> scannedPackageSet, Class<? extends A> ... packageAnnotationTypes) {
        Map<Package, Set<A>> retmap = MapUtils.initializedMap(new LinkedHashSetFactory());
        if (scannedPackageSet != null && packageAnnotationTypes.length > 0) {
            for (Package package_ : scannedPackageSet) {
                for (Class<A> clazz : packageAnnotationTypes) {
                    A annotation = package_.getAnnotation(clazz);
                    if (annotation == null) continue;
                    retmap.get(package_).add(annotation);
                }
            }
        }
        return retmap;
    }

    public static <T> Class<T> classForName(String className) {
        Class<?> retval = null;
        try {
            Class<?> forName;
            retval = forName = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static <E> E invokeMethod(Object object, String methodName, Object ... arguments) {
        Object retval;
        block6: {
            retval = null;
            try {
                Class<?>[] parameterTypes = ReflectionUtils.determineParameterTypesFromArguments(arguments);
                if (object == null) break block6;
                boolean isClass = object instanceof Class;
                Class<?> type = isClass ? (Class<?>)object : object.getClass();
                Method declaredMethod = null;
                try {
                    declaredMethod = type.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (Exception e) {
                    for (Method method : type.getDeclaredMethods()) {
                        Class<?>[] parameterTypesOfMethod;
                        boolean areAssignableFrom;
                        String name = method.getName();
                        if (!StringUtils.equals((CharSequence)methodName, (CharSequence)name) || !(areAssignableFrom = ReflectionUtils.areAssignableFrom(parameterTypesOfMethod = method.getParameterTypes(), parameterTypes))) continue;
                        declaredMethod = method;
                        break;
                    }
                }
                if (declaredMethod != null) {
                    retval = declaredMethod.invoke(isClass ? null : object, arguments);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (E)retval;
    }

    public static class MethodParameterMetaInformation {
        private Class<?> type = null;
        private List<Annotation> declaredAnnotationList = null;

        public MethodParameterMetaInformation(Class<?> type, List<Annotation> declaredAnnotationList) {
            this.type = type;
            this.declaredAnnotationList = declaredAnnotationList;
        }

        public Class<?> getType() {
            return this.type;
        }

        public List<Annotation> getDeclaredAnnotationList() {
            return this.declaredAnnotationList;
        }
    }
}

