/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.sorting;

public class SortUtil {
    public static void mergeSort(ArbitraryStructureContext arbitraryStructureContext, ComparableArbitraryStructureIndexPosition comparableArbitraryStructureIndexPosition, MergeSortDataModify mergeSortDataModify, boolean ascending) {
        ArbitraryStructureContextImpl collectionWideContext = new ArbitraryStructureContextImpl(arbitraryStructureContext);
        if (!collectionWideContext.isToBeSortedPrimitive()) {
            int leftPosition = arbitraryStructureContext.getStartIndexPosition();
            int middlePosition = (arbitraryStructureContext.getEndIndexPosition() + arbitraryStructureContext.getStartIndexPosition()) / 2;
            int rightPosition = arbitraryStructureContext.getEndIndexPosition();
            ArbitraryStructureContextImpl leftCollectionContext = new ArbitraryStructureContextImpl(leftPosition, middlePosition);
            ArbitraryStructureContextImpl rightCollectionContext = new ArbitraryStructureContextImpl(middlePosition + 1, rightPosition);
            SortUtil.mergeSort(leftCollectionContext, comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
            SortUtil.mergeSort(rightCollectionContext, comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
            SortUtil.mergeSortedParts(leftCollectionContext, rightCollectionContext, comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
        } else {
            SortUtil.sortPrimitive(arbitraryStructureContext, comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
        }
    }

    private static void mergeSortedParts(ArbitraryStructureContext leftArbitraryStructureContext, ArbitraryStructureContext rightArbitraryStructureContext, ComparableArbitraryStructureIndexPosition comparableArbitraryStructureIndexPosition, MergeSortDataModify mergeSortDataModify, boolean ascending) {
        int iCurrentIndexPosition;
        int compareFactor = ascending ? 1 : -1;
        int leftCurrentIndexPosition = leftArbitraryStructureContext.getStartIndexPosition();
        int rightCurrentIndexPosition = rightArbitraryStructureContext.getStartIndexPosition();
        while (leftCurrentIndexPosition <= leftArbitraryStructureContext.getEndIndexPosition() && rightCurrentIndexPosition <= rightArbitraryStructureContext.getEndIndexPosition()) {
            int compare = compareFactor * comparableArbitraryStructureIndexPosition.compare(leftCurrentIndexPosition, rightCurrentIndexPosition);
            if (compare > 0) {
                mergeSortDataModify.pushOnStack(rightCurrentIndexPosition++);
                continue;
            }
            mergeSortDataModify.pushOnStack(leftCurrentIndexPosition++);
        }
        while (leftCurrentIndexPosition <= leftArbitraryStructureContext.getEndIndexPosition()) {
            mergeSortDataModify.pushOnStack(leftCurrentIndexPosition++);
        }
        while (rightCurrentIndexPosition <= rightArbitraryStructureContext.getEndIndexPosition()) {
            mergeSortDataModify.pushOnStack(rightCurrentIndexPosition++);
        }
        for (iCurrentIndexPosition = rightArbitraryStructureContext.getEndIndexPosition(); iCurrentIndexPosition >= rightArbitraryStructureContext.getStartIndexPosition(); --iCurrentIndexPosition) {
            mergeSortDataModify.popFromStack(iCurrentIndexPosition);
        }
        for (iCurrentIndexPosition = leftArbitraryStructureContext.getEndIndexPosition(); iCurrentIndexPosition >= leftArbitraryStructureContext.getStartIndexPosition(); --iCurrentIndexPosition) {
            mergeSortDataModify.popFromStack(iCurrentIndexPosition);
        }
    }

    private static void sortPrimitive(ArbitraryStructureContext arbitraryStructureContext, ComparableArbitraryStructureIndexPosition comparableArbitraryStructureIndexPosition, MergeSortDataModify mergeSortDataModify, boolean ascending) {
        int orderFactor;
        int collectionSize = arbitraryStructureContext.getEndIndexPosition() - arbitraryStructureContext.getStartIndexPosition() + 1;
        int n = orderFactor = ascending ? 1 : -1;
        if (collectionSize == 2) {
            int indexPosition2;
            int indexPosition1 = arbitraryStructureContext.getStartIndexPosition();
            int compare = orderFactor * comparableArbitraryStructureIndexPosition.compare(indexPosition1, indexPosition2 = arbitraryStructureContext.getEndIndexPosition());
            if (compare > 0) {
                new MergeSortDataSwap(mergeSortDataModify).swap(indexPosition1, indexPosition2);
            }
        } else if (collectionSize == 3) {
            SortUtil.sortPrimitive(new ArbitraryStructureContextImpl(arbitraryStructureContext.getStartIndexPosition(), arbitraryStructureContext.getStartIndexPosition() + 1), comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
            SortUtil.sortPrimitive(new ArbitraryStructureContextImpl(arbitraryStructureContext.getStartIndexPosition() + 1, arbitraryStructureContext.getStartIndexPosition() + 2), comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
            SortUtil.sortPrimitive(new ArbitraryStructureContextImpl(arbitraryStructureContext.getStartIndexPosition(), arbitraryStructureContext.getStartIndexPosition() + 1), comparableArbitraryStructureIndexPosition, mergeSortDataModify, ascending);
        }
    }

    private static class ArbitraryStructureContextImpl
    implements ArbitraryStructureContext {
        private int startIndexPosition = -1;
        private int endIndexPosition = -1;

        public ArbitraryStructureContextImpl(int startIndexPosition, int endIndexPosition) {
            this.startIndexPosition = startIndexPosition;
            this.endIndexPosition = endIndexPosition;
        }

        public ArbitraryStructureContextImpl(ArbitraryStructureContext arbitraryStructureContext) {
            this(arbitraryStructureContext.getStartIndexPosition(), arbitraryStructureContext.getEndIndexPosition());
        }

        private boolean isToBeSortedPrimitive() {
            boolean retval = false;
            if (this.endIndexPosition - this.startIndexPosition + 1 <= 3) {
                retval = true;
            }
            return retval;
        }

        @Override
        public int getEndIndexPosition() {
            return this.endIndexPosition;
        }

        @Override
        public int getStartIndexPosition() {
            return this.startIndexPosition;
        }
    }

    public static interface ArbitraryStructureContext {
        public int getStartIndexPosition();

        public int getEndIndexPosition();
    }

    public static interface ComparableArbitraryStructureIndexPosition {
        public int compare(int var1, int var2);
    }

    private static class MergeSortDataSwap {
        private MergeSortDataModify mergeSortDataModify = null;

        public MergeSortDataSwap(MergeSortDataModify mergeSortDataModify) {
            this.mergeSortDataModify = mergeSortDataModify;
        }

        public void swap(int sourceIndexPosition, int destinationIndexPosition) {
            this.mergeSortDataModify.pushOnStack(sourceIndexPosition);
            this.mergeSortDataModify.pushOnStack(destinationIndexPosition);
            this.mergeSortDataModify.popFromStack(sourceIndexPosition);
            this.mergeSortDataModify.popFromStack(destinationIndexPosition);
        }
    }

    public static interface MergeSortDataModify {
        public void pushOnStack(int var1);

        public void popFromStack(int var1);
    }
}

