/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.store;

import java.io.File;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.store.DirectoryBasedObjectStoreAbstract;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;
import org.omnaest.utils.xml.JAXBXMLHelper;

public class DirectoryBasedObjectStoreUsingJAXB<E>
extends DirectoryBasedObjectStoreAbstract<E> {
    private static final long serialVersionUID = -3189372961705877115L;

    public DirectoryBasedObjectStoreUsingJAXB(File baseDirectory, final ExceptionHandlerSerializable exceptionHandler, final Class<E> elementType) {
        super(new ElementBidirectionalConverterSerializable<ByteArrayContainer, E>(){
            private static final long serialVersionUID = -8113632185474907757L;

            @Override
            public E convert(ByteArrayContainer byteArrayContainer) {
                JAXBXMLHelper.UnmarshallingConfiguration unmarshallingConfiguration = this.newUnmarshallingConfiguration(exceptionHandler, elementType);
                JAXBXMLHelper.JAXBContextBasedUnmarshaller jaxbContextBasedUnmarshaller = JAXBXMLHelper.newJAXBContextBasedUnmarshaller(elementType, unmarshallingConfiguration);
                JAXBElement element = jaxbContextBasedUnmarshaller.unmarshalAsJAXBElement(byteArrayContainer.getInputStream());
                return element != null ? element.getValue() : null;
            }

            private JAXBXMLHelper.UnmarshallingConfiguration newUnmarshallingConfiguration(ExceptionHandlerSerializable exceptionHandler2, Class<E> elementType2) {
                JAXBXMLHelper.UnmarshallingConfiguration retval = new JAXBXMLHelper.UnmarshallingConfiguration();
                retval.setExceptionHandler(exceptionHandler2);
                if (ArrayUtils.isArrayType(elementType2)) {
                    retval.setKnownTypes(new Class[]{elementType2, ArrayUtils.componentType(elementType2)});
                } else {
                    retval.setKnownTypes(new Class[]{elementType2});
                }
                return retval;
            }

            private JAXBXMLHelper.MarshallingConfiguration newMarshallingConfiguration(ExceptionHandlerSerializable exceptionHandler2, Class<E> elementType2) {
                JAXBXMLHelper.MarshallingConfiguration retval = new JAXBXMLHelper.MarshallingConfiguration();
                retval.setExceptionHandler(exceptionHandler2);
                if (ArrayUtils.isArrayType(elementType2)) {
                    retval.setKnownTypes(new Class[]{elementType2, ArrayUtils.componentType(elementType2)});
                } else {
                    retval.setKnownTypes(new Class[]{elementType2});
                }
                return retval;
            }

            @Override
            public ByteArrayContainer convertBackwards(E element) {
                QName name = new QName("element");
                Class declaredType = elementType;
                Object value = element;
                JAXBXMLHelper.MarshallingConfiguration marshallingConfiguration = this.newMarshallingConfiguration(exceptionHandler, elementType);
                return new ByteArrayContainer().copyFrom(JAXBXMLHelper.storeObjectAsXML((Object)new JAXBElement(name, declaredType, value), marshallingConfiguration));
            }
        }, baseDirectory, exceptionHandler);
    }
}

