/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.store;

import java.io.File;
import java.io.Serializable;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.store.DirectoryBasedObjectStoreAbstract;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;

public class DirectoryBasedObjectStoreUsingSerializable<E extends Serializable>
extends DirectoryBasedObjectStoreAbstract<E> {
    private static final long serialVersionUID = -3189372961705877115L;

    public DirectoryBasedObjectStoreUsingSerializable(File baseDirectory, ExceptionHandlerSerializable exceptionHandler) {
        super(new ElementBidirectionalConverterSerializable<ByteArrayContainer, E>(){
            private static final long serialVersionUID = -7311719190343731231L;

            @Override
            public E convert(ByteArrayContainer byteArrayContainer) {
                return byteArrayContainer.toDeserializedElement();
            }

            @Override
            public ByteArrayContainer convertBackwards(E element) {
                return new ByteArrayContainer().copyFromAsSerialized(element);
            }
        }, baseDirectory, exceptionHandler);
    }
}

