/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.store;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.store.DirectoryBasedObjectStoreAbstract;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;

public class DirectoryBasedObjectStoreUsingXStream<E>
extends DirectoryBasedObjectStoreAbstract<E> {
    private static final long serialVersionUID = -3189372961705877115L;

    public DirectoryBasedObjectStoreUsingXStream(File baseDirectory, ExceptionHandlerSerializable exceptionHandler) {
        super(new ElementBidirectionalConverterSerializable<ByteArrayContainer, E>(){
            private static final long serialVersionUID = -7311719190343731231L;
            private XStream xStream = new XStream();

            @Override
            public E convert(ByteArrayContainer byteArrayContainer) {
                return this.xStream.fromXML(byteArrayContainer.toString());
            }

            @Override
            public ByteArrayContainer convertBackwards(E element) {
                return new ByteArrayContainer().copyFrom(this.xStream.toXML(element));
            }
        }, baseDirectory, exceptionHandler);
    }
}

