/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.store;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.events.exception.ExceptionHandlerSerializable;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerBooleanState;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.element.cached.CachedElement;
import org.omnaest.utils.structure.element.cached.CachedElementTimed;

public class NestedDirectoryToByteArrayContainerListAdapter
extends ListAbstract<ByteArrayContainer> {
    private static final long serialVersionUID = 2675512592103223050L;
    private final File baseDirectory;
    private final ExceptionHandlerSerializable exceptionHandler;
    private CachedElementTimed<Integer> cachedSize = new CachedElementTimed<Integer>(new CachedElement.ValueResolver<Integer>(){

        @Override
        public Integer resolveValue() {
            return NestedDirectoryToByteArrayContainerListAdapter.this.determineSize();
        }
    }, 30000L);

    public NestedDirectoryToByteArrayContainerListAdapter(File baseDirectory) {
        this(baseDirectory, new ExceptionHandlerIgnoring());
    }

    public NestedDirectoryToByteArrayContainerListAdapter(File baseDirectory, ExceptionHandlerSerializable exceptionHandlerSerializable) {
        this.exceptionHandler = exceptionHandlerSerializable;
        Assert.isNotNull((Object)baseDirectory, "baseDirectory must not be null");
        boolean exists = baseDirectory.exists();
        Assert.isTrue(!exists || baseDirectory.isDirectory());
        this.baseDirectory = baseDirectory;
    }

    @Override
    public boolean add(ByteArrayContainer byteArrayContainer) {
        if (byteArrayContainer == null) {
            byteArrayContainer = new ByteArrayContainer();
        }
        int index = this.size();
        ExceptionHandlerBooleanState exceptionHandler = new ExceptionHandlerBooleanState();
        File file = this.determineFileForIndex(index);
        ByteArrayContainer container = ByteArrayContainer.valueOf(byteArrayContainer);
        container.setExceptionHandler(exceptionHandler);
        container.writeTo(file);
        this.cachedSize.clearCache();
        return exceptionHandler.hasNoErrors();
    }

    @Override
    public void add(int index, ByteArrayContainer byteArrayContainer) {
        if (byteArrayContainer == null) {
            byteArrayContainer = new ByteArrayContainer();
        }
        File file = this.determineFileForIndex(index);
        byteArrayContainer.writeTo(file);
        this.cachedSize.clearCache();
    }

    private Collection<File> determineFileCollection() {
        NameFileFilter fileFilter = new NameFileFilter(new String[]{"0.dat", "1.dat", "2.dat", "3.dat", "4.dat", "5.dat", "6.dat", "7.dat", "8.dat", "9.dat"});
        Collection listFiles = FileUtils.listFiles((File)this.getBaseDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        return listFiles;
    }

    private File determineFileForIndex(int index) {
        File file = this.getBaseDirectory();
        char[] indexTokens = String.valueOf(index).toCharArray();
        char[] directoryNames = Arrays.copyOf(indexTokens, indexTokens.length - 1);
        char fileName = indexTokens[indexTokens.length - 1];
        for (char directoryName : directoryNames) {
            if ((file = new File(file, String.valueOf(directoryName))).exists()) continue;
            file.mkdir();
        }
        file = new File(file, String.valueOf(fileName) + ".dat");
        return file;
    }

    @Override
    public ByteArrayContainer get(int index) {
        ByteArrayContainer retval = null;
        try {
            File file = this.determineFileForIndex(index);
            retval = new ByteArrayContainer().copyFrom(file);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return retval;
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteArrayContainer remove(int index) {
        ByteArrayContainer retval = this.get(index);
        try {
            File file = this.determineFileForIndex(index);
            NestedDirectoryToByteArrayContainerListAdapter.deleteFileOrDirectory(file);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        this.cachedSize.clearCache();
        return retval;
    }

    private static void deleteFileOrDirectory(File file) throws IOException {
        if (file.exists()) {
            FileUtils.forceDelete((File)file);
        }
    }

    @Override
    public ByteArrayContainer set(int index, ByteArrayContainer byteArrayContainer) {
        ByteArrayContainer retval = this.get(index);
        if (byteArrayContainer == null) {
            byteArrayContainer = new ByteArrayContainer();
        }
        try {
            File file = this.determineFileForIndex(index);
            byteArrayContainer.writeTo(file);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return retval;
    }

    @Override
    public int size() {
        return (Integer)this.cachedSize.getValue();
    }

    private int determineSize() {
        int size = 0;
        try {
            Collection<File> listFiles = this.determineFileCollection();
            size = listFiles.size();
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
        return size;
    }

    @Override
    public void clear() {
        try {
            NestedDirectoryToByteArrayContainerListAdapter.deleteFileOrDirectory(this.getBaseDirectory());
            this.cachedSize.clearCache();
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
    }

    private File getBaseDirectory() {
        if (!this.baseDirectory.exists()) {
            this.baseDirectory.mkdir();
        }
        return this.baseDirectory;
    }
}

