/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.streams;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class StreamConnector {
    public static void connect(InputStream inputStream, OutputStream outputStream) throws IOException {
        int reader = 0;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        while ((reader = bis.read()) != -1) {
            bos.write(reader);
        }
        bos.flush();
    }

    public static TransferResult transfer(InputStream inputStream, OutputStream outputStream) {
        TransferResult transferResult = null;
        if (inputStream != null && outputStream != null) {
            int numberOfBytesRead = 0;
            try {
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                BufferedOutputStream bos = new BufferedOutputStream(outputStream);
                byte[] buffer = new byte[10000];
                int bufferSizeUsed = 0;
                while ((bufferSizeUsed = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bufferSizeUsed);
                    numberOfBytesRead += bufferSizeUsed;
                }
                bos.flush();
                Boolean successful = true;
                Integer transferSizeInBytes = numberOfBytesRead;
                Exception exception = null;
                transferResult = new TransferResult(successful, transferSizeInBytes, exception);
            }
            catch (Exception e) {
                Boolean successful = false;
                Integer transferSizeInBytes = numberOfBytesRead;
                Exception exception = e;
                transferResult = new TransferResult(successful, transferSizeInBytes, exception);
            }
        } else {
            Boolean successful = false;
            Integer transferSizeInBytes = 0;
            Exception exception = null;
            transferResult = new TransferResult(successful, transferSizeInBytes, exception);
        }
        return transferResult;
    }

    public static void connect(InputStream source, StringBuffer destination, String encoding) throws IOException {
        if (source != null && destination != null) {
            InputStreamReader isr = new InputStreamReader(source, encoding);
            char[] charBuffer = new char[100];
            int count = 0;
            while ((count = isr.read(charBuffer)) > 0) {
                destination.append(charBuffer, 0, count);
            }
            source.close();
        }
    }

    public static void connect(StringBuffer source, OutputStream destination, String encoding) throws IOException {
        if (source != null && destination != null) {
            OutputStreamWriter osw = new OutputStreamWriter(destination, encoding);
            osw.write(source.toString());
            osw.close();
        }
    }

    public static class TransferResult {
        protected boolean successful = false;
        protected int transferSizeInBytes = 0;
        protected Exception exception = null;

        public TransferResult(boolean successful, int transferSizeInBytes, Exception exception) {
            this.successful = successful;
            this.transferSizeInBytes = transferSizeInBytes;
            this.exception = exception;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public int getTransferSizeInBytes() {
            return this.transferSizeInBytes;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

